/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MoundFeature
extends Feature<NoneFeatureConfiguration> {
    public MoundFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_().m_6625_(2);
        RandomSource random = context.m_225041_();
        BlockState state = level.m_8055_(context.m_159777_().m_7495_());
        if (state.m_204336_(JNETags.Blocks.MOUND_BLOCKS)) {
            int height = 3 + random.m_188503_(4);
            this.placeMound(level, origin, height, state, random);
            int extraMound = 1 + random.m_188503_(3);
            for (int i = 0; i < extraMound; ++i) {
                int x = (random.m_188499_() ? 1 : -1) * 3;
                int z = (random.m_188499_() ? 1 : -1) * 3;
                int extraMoundHeight = 3 + random.m_188503_(4);
                this.placeMound(level, origin.m_7918_(x, 0, z), extraMoundHeight, state, random);
            }
            return true;
        }
        return false;
    }

    private void placeMound(WorldGenLevel level, BlockPos origin, int height, BlockState state, RandomSource random) {
        int radius = 3;
        for (int y = 0; y < height; ++y) {
            BlockPos center = origin.m_6630_(y);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos;
                    double distanceSquared = ((double)x + 0.5) * ((double)x + 0.5) + ((double)z + 0.5) * ((double)z + 0.5);
                    if (!(distanceSquared <= (double)(radius * radius)) || !level.m_8055_((pos = center.m_7918_(x, 0, z)).m_7495_()).m_280296_() || !level.m_8055_(pos).m_247087_()) continue;
                    level.m_7731_(pos, state, 2);
                }
            }
        }
        int terrainX = random.m_188503_(9) - 4;
        int terrainZ = random.m_188503_(9) - 4;
        BlockPos circleCenter = origin.m_6630_(height).m_7918_(terrainX, 0, terrainZ);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos pos;
                double distanceSquared = ((double)x + 0.5) * ((double)x + 0.5) + ((double)z + 0.5) * ((double)z + 0.5);
                if (!(distanceSquared <= (double)(radius * radius)) || !level.m_8055_((pos = circleCenter.m_7918_(x, 0, z)).m_7495_()).m_204336_(JNETags.Blocks.MOUND_BLOCKS) || !level.m_8055_(pos).m_247087_()) continue;
                level.m_7731_(pos, state, 2);
            }
        }
    }
}

