/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.phys.Vec3;

public class LargeBlackIceFeature
extends Feature<LargeDripstoneConfiguration> {
    public LargeBlackIceFeature(Codec<LargeDripstoneConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<LargeDripstoneConfiguration> pContext) {
        Object t;
        WorldGenLevel $$1 = pContext.m_159774_();
        BlockPos $$2 = pContext.m_159777_();
        LargeDripstoneConfiguration $$3 = (LargeDripstoneConfiguration)pContext.m_159778_();
        RandomSource $$4 = pContext.m_225041_();
        if (!LargeBlackIceFeature.isEmptyOrWater((LevelAccessor)$$1, $$2)) {
            return false;
        }
        Optional $$5 = Column.m_158175_((LevelSimulatedReader)$$1, (BlockPos)$$2, (int)$$3.f_160945_, DripstoneUtils::m_159664_, LargeBlackIceFeature::isBlackIceBaseOrLava);
        if ($$5.isPresent() && (t = $$5.get()) instanceof Column.Range) {
            Column.Range $$6 = (Column.Range)t;
            if ($$6.m_158214_() < 4) {
                return false;
            }
            int $$7 = (int)((float)$$6.m_158214_() * $$3.f_160948_);
            int $$8 = Mth.m_14045_((int)$$7, (int)$$3.f_160946_.m_142739_(), (int)$$3.f_160946_.m_142737_());
            int $$9 = Mth.m_216287_((RandomSource)$$4, (int)$$3.f_160946_.m_142739_(), (int)$$8);
            LargeBlackIce $$10 = LargeBlackIceFeature.makeBlackIce($$2.m_175288_($$6.m_158212_() - 1), false, $$4, $$9, $$3.f_160949_, $$3.f_160947_);
            LargeBlackIce $$11 = LargeBlackIceFeature.makeBlackIce($$2.m_175288_($$6.m_158213_() + 1), true, $$4, $$9, $$3.f_160950_, $$3.f_160947_);
            WindOffsetter $$13 = $$10.isSuitableForWind($$3) && $$11.isSuitableForWind($$3) ? new WindOffsetter($$2.m_123342_(), $$4, $$3.f_160951_) : WindOffsetter.noWind();
            boolean $$14 = $$10.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary($$1, $$13);
            boolean $$15 = $$11.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary($$1, $$13);
            if ($$14) {
                $$10.placeBlocks($$1, $$4, $$13);
            }
            if ($$15) {
                $$11.placeBlocks($$1, $$4, $$13);
            }
            return true;
        }
        return false;
    }

    private static LargeBlackIce makeBlackIce(BlockPos pRoot, boolean pPointingUp, RandomSource pRandom, int pRadius, FloatProvider pBluntnessBase, FloatProvider pScaleBase) {
        return new LargeBlackIce(pRoot, pPointingUp, pRadius, pBluntnessBase.m_214084_(pRandom), pScaleBase.m_214084_(pRandom));
    }

    protected static boolean isEmptyOrWater(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, DripstoneUtils::m_159664_);
    }

    protected static double getDripstoneHeight(double pRadius, double pMaxRadius, double pScale, double pMinRadius) {
        if (pRadius < pMinRadius) {
            pRadius = pMinRadius;
        }
        double $$5 = pRadius / pMaxRadius * 0.384;
        double $$6 = 0.75 * Math.pow($$5, 1.3333333333333333);
        double $$7 = Math.pow($$5, 0.6666666666666666);
        double $$8 = 0.3333333333333333 * Math.log($$5);
        double $$9 = pScale * ($$6 - $$7 - $$8);
        $$9 = Math.max($$9, 0.0);
        return $$9 / 0.384 * pMaxRadius;
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, DripstoneUtils::m_159666_);
    }

    protected static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel pLevel, BlockPos pPos, int pRadius) {
        if (LargeBlackIceFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos)) {
            return false;
        }
        float $$4 = 6.0f / (float)pRadius;
        for (float $$5 = 0.0f; $$5 < (float)Math.PI * 2; $$5 += $$4) {
            int $$7;
            int $$6 = (int)(Mth.m_14089_((float)$$5) * (float)pRadius);
            if (!LargeBlackIceFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos.m_7918_($$6, 0, $$7 = (int)(Mth.m_14031_((float)$$5) * (float)pRadius)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlackIceBaseOrLava(BlockState pState) {
        return LargeBlackIceFeature.isBlackIceBase(pState) || pState.m_60713_(Blocks.f_49991_);
    }

    public static boolean isBlackIceBase(BlockState pState) {
        return pState.m_60713_((Block)JNEBlocks.BLACK_ICE.get()) || pState.m_204336_(JNETags.Blocks.BLACK_ICE_REPLACEABLE);
    }

    static final class LargeBlackIce {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeBlackIce(BlockPos pRoot, boolean pPointingUp, int pRadius, double pBluntness, double pScale) {
            this.root = pRoot;
            this.pointingUp = pPointingUp;
            this.radius = pRadius;
            this.bluntness = pBluntness;
            this.scale = pScale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel pLevel, WindOffsetter pWindOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos $$2 = this.root.m_122032_();
                int $$3 = Math.min(10, this.getHeight());
                for (int $$4 = 0; $$4 < $$3; ++$$4) {
                    if (pLevel.m_8055_((BlockPos)$$2).m_60713_(Blocks.f_49991_)) {
                        return false;
                    }
                    if (LargeBlackIceFeature.isCircleMostlyEmbeddedInStone(pLevel, pWindOffsetter.offset((BlockPos)$$2), this.radius)) {
                        this.root = $$2;
                        return true;
                    }
                    $$2.m_122173_(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float pRadius) {
            return (int)LargeBlackIceFeature.getDripstoneHeight(pRadius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel pLevel, RandomSource pRandom, WindOffsetter pWindOffsetter) {
            for (int $$3 = -this.radius; $$3 <= this.radius; ++$$3) {
                block1: for (int $$4 = -this.radius; $$4 <= this.radius; ++$$4) {
                    int $$6;
                    float $$5 = Mth.m_14116_((float)($$3 * $$3 + $$4 * $$4));
                    if ($$5 > (float)this.radius || ($$6 = this.getHeightAtRadius($$5)) <= 0) continue;
                    if ((double)pRandom.m_188501_() < 0.2) {
                        $$6 = (int)((float)$$6 * Mth.m_216283_((RandomSource)pRandom, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos $$7 = this.root.m_7918_($$3, 0, $$4).m_122032_();
                    boolean $$8 = false;
                    int $$9 = this.pointingUp ? pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, $$7.m_123341_(), $$7.m_123343_()) : Integer.MAX_VALUE;
                    for (int $$10 = 0; $$10 < $$6 && $$7.m_123342_() < $$9; ++$$10) {
                        BlockPos $$11 = pWindOffsetter.offset((BlockPos)$$7);
                        if (LargeBlackIceFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, $$11)) {
                            $$8 = true;
                            Block $$12 = (Block)JNEBlocks.BLACK_ICE.get();
                            pLevel.m_7731_($$11, $$12.m_49966_(), 2);
                        } else if ($$8 && pLevel.m_8055_($$11).m_204336_(BlockTags.f_13061_)) continue block1;
                        $$7.m_122173_(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargeDripstoneConfiguration pConfig) {
            return this.radius >= pConfig.f_160952_ && this.bluntness >= (double)pConfig.f_160953_;
        }
    }

    private static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int pOriginY, RandomSource pRandom, FloatProvider pMagnitude) {
            this.originY = pOriginY;
            float $$3 = pMagnitude.m_214084_(pRandom);
            float $$4 = Mth.m_216283_((RandomSource)pRandom, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.m_14089_((float)$$4) * $$3), 0.0, (double)(Mth.m_14031_((float)$$4) * $$3));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos pPos) {
            if (this.windSpeed == null) {
                return pPos;
            }
            int $$1 = this.originY - pPos.m_123342_();
            Vec3 $$2 = this.windSpeed.m_82490_((double)$$1);
            return pPos.m_7918_(Mth.m_14107_((double)$$2.f_82479_), 0, Mth.m_14107_((double)$$2.f_82481_));
        }
    }
}

