/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;

public class BlackIcicleFeature
extends Feature<PointedDripstoneConfiguration> {
    public BlackIcicleFeature(Codec<PointedDripstoneConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<PointedDripstoneConfiguration> pContext) {
        WorldGenLevel $$1 = pContext.m_159774_();
        BlockPos $$2 = pContext.m_159777_();
        RandomSource $$3 = pContext.m_225041_();
        PointedDripstoneConfiguration $$4 = (PointedDripstoneConfiguration)pContext.m_159778_();
        Optional<Direction> $$5 = BlackIcicleFeature.getTipDirection((LevelAccessor)$$1, $$2, $$3);
        if ($$5.isEmpty()) {
            return false;
        }
        BlockPos $$6 = $$2.m_121945_($$5.get().m_122424_());
        BlackIcicleFeature.createPatchOfBlackIce((LevelAccessor)$$1, $$3, $$6, $$4);
        int $$7 = $$3.m_188501_() < $$4.f_191275_ && DripstoneUtils.m_159664_((BlockState)$$1.m_8055_($$2.m_121945_($$5.get()))) ? 2 : 1;
        BlackIcicleFeature.growBlackIcicle((LevelAccessor)$$1, $$2, $$5.get(), $$7, false);
        return true;
    }

    private static Optional<Direction> getTipDirection(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        boolean $$3 = DripstoneUtils.m_159662_((BlockState)pLevel.m_8055_(pPos.m_7494_()));
        boolean $$4 = DripstoneUtils.m_159662_((BlockState)pLevel.m_8055_(pPos.m_7495_()));
        if ($$3 && $$4) {
            return Optional.of(pRandom.m_188499_() ? Direction.DOWN : Direction.UP);
        }
        if ($$3) {
            return Optional.of(Direction.DOWN);
        }
        return $$4 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void createPatchOfBlackIce(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, PointedDripstoneConfiguration pConfig) {
        BlackIcicleFeature.placeBlackIceIfPossible(pLevel, pPos);
        for (Direction $$4 : Direction.Plane.HORIZONTAL) {
            if (pRandom.m_188501_() > pConfig.f_191276_) continue;
            BlockPos $$5 = pPos.m_121945_($$4);
            BlackIcicleFeature.placeBlackIceIfPossible(pLevel, $$5);
            if (pRandom.m_188501_() > pConfig.f_191277_) continue;
            BlockPos $$6 = $$5.m_121945_(Direction.m_235672_((RandomSource)pRandom));
            BlackIcicleFeature.placeBlackIceIfPossible(pLevel, $$6);
            if (pRandom.m_188501_() > pConfig.f_191278_) continue;
            BlockPos $$7 = $$6.m_121945_(Direction.m_235672_((RandomSource)pRandom));
            BlackIcicleFeature.placeBlackIceIfPossible(pLevel, $$7);
        }
    }

    protected static void growBlackIcicle(LevelAccessor pLevel, BlockPos pPos, Direction pDirection, int pHeight, boolean pMergeTip) {
        if (BlackIcicleFeature.isBlackIceBaseOrLava(pLevel.m_8055_(pPos.m_121945_(pDirection.m_122424_())))) {
            BlockPos.MutableBlockPos $$5 = pPos.m_122032_();
            BlackIcicleFeature.buildBaseToTipColumn(pDirection, pHeight, pMergeTip, p_277326_ -> {
                if (p_277326_.m_60713_((Block)JNEBlocks.BLACK_ICICLE.get())) {
                    p_277326_ = (BlockState)p_277326_.m_61124_((Property)PointedDripstoneBlock.f_154011_, (Comparable)Boolean.valueOf(pLevel.m_46801_((BlockPos)$$5)));
                }
                pLevel.m_7731_((BlockPos)$$5, p_277326_, 2);
                $$5.m_122173_(pDirection);
            });
        }
    }

    protected static boolean placeBlackIceIfPossible(LevelAccessor pLevel, BlockPos pPos) {
        BlockState $$2 = pLevel.m_8055_(pPos);
        if ($$2.m_204336_(JNETags.Blocks.BLACK_ICE_REPLACEABLE)) {
            pLevel.m_7731_(pPos, ((Block)JNEBlocks.BLACK_ICE.get()).m_49966_(), 2);
            return true;
        }
        return false;
    }

    public static boolean isBlackIceBaseOrLava(BlockState pState) {
        return BlackIcicleFeature.isBlackIceBase(pState) || pState.m_60713_(Blocks.f_49991_);
    }

    public static boolean isBlackIceBase(BlockState pState) {
        return pState.m_60713_((Block)JNEBlocks.BLACK_ICE.get()) || pState.m_204336_(JNETags.Blocks.BLACK_ICE_REPLACEABLE);
    }

    protected static void buildBaseToTipColumn(Direction pDirection, int pHeight, boolean pMergeTip, Consumer<BlockState> pBlockSetter) {
        if (pHeight >= 3) {
            pBlockSetter.accept(BlackIcicleFeature.createBlackIcicle(pDirection, DripstoneThickness.BASE));
            for (int $$4 = 0; $$4 < pHeight - 3; ++$$4) {
                pBlockSetter.accept(BlackIcicleFeature.createBlackIcicle(pDirection, DripstoneThickness.MIDDLE));
            }
        }
        if (pHeight >= 2) {
            pBlockSetter.accept(BlackIcicleFeature.createBlackIcicle(pDirection, DripstoneThickness.FRUSTUM));
        }
        if (pHeight >= 1) {
            pBlockSetter.accept(BlackIcicleFeature.createBlackIcicle(pDirection, pMergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    private static BlockState createBlackIcicle(Direction pDirection, DripstoneThickness pDripstoneThickness) {
        return (BlockState)((BlockState)((Block)JNEBlocks.BLACK_ICICLE.get()).m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)pDirection)).m_61124_((Property)PointedDripstoneBlock.f_154010_, (Comparable)pDripstoneThickness);
    }
}

