/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class BlackIceClusterFeature
extends Feature<DripstoneClusterConfiguration> {
    public BlackIceClusterFeature(Codec<DripstoneClusterConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<DripstoneClusterConfiguration> pContext) {
        WorldGenLevel $$1 = pContext.m_159774_();
        BlockPos $$2 = pContext.m_159777_();
        DripstoneClusterConfiguration $$3 = (DripstoneClusterConfiguration)pContext.m_159778_();
        RandomSource $$4 = pContext.m_225041_();
        if (!BlackIceClusterFeature.isEmptyOrWater((LevelAccessor)$$1, $$2)) {
            return false;
        }
        int $$5 = $$3.f_160760_.m_214085_($$4);
        float $$6 = $$3.f_160766_.m_214084_($$4);
        float $$7 = $$3.f_160765_.m_214084_($$4);
        int $$8 = $$3.f_160761_.m_214085_($$4);
        int $$9 = $$3.f_160761_.m_214085_($$4);
        for (int $$10 = -$$8; $$10 <= $$8; ++$$10) {
            for (int $$11 = -$$9; $$11 <= $$9; ++$$11) {
                double $$12 = this.getChanceOfStalagmiteOrStalactite($$8, $$9, $$10, $$11, $$3);
                BlockPos $$13 = $$2.m_7918_($$10, 0, $$11);
                this.placeColumn($$1, $$4, $$13, $$10, $$11, $$6, $$12, $$5, $$7, $$3);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel pLevel, RandomSource pRandom, BlockPos pPos, int pX, int pZ, float pWetness, double pChance, int pHeight, float pDensity, DripstoneClusterConfiguration pConfig) {
        Optional $$10 = Column.m_158175_((LevelSimulatedReader)pLevel, (BlockPos)pPos, (int)pConfig.f_160759_, DripstoneUtils::m_159664_, DripstoneUtils::m_203130_);
        if ($$10.isPresent()) {
            OptionalInt $$11 = ((Column)$$10.get()).m_142011_();
            OptionalInt $$12 = ((Column)$$10.get()).m_142009_();
            if ($$11.isPresent() || $$12.isPresent()) {
                boolean $$39;
                int $$38;
                int $$37;
                boolean $$24;
                int $$23;
                int $$28;
                boolean $$18;
                Column $$16;
                boolean $$13;
                boolean bl = $$13 = pRandom.m_188501_() < pWetness;
                if ($$13 && $$12.isPresent() && this.canPlacePool(pLevel, pPos.m_175288_($$12.getAsInt()))) {
                    int $$14 = $$12.getAsInt();
                    $$16 = ((Column)$$10.get()).m_158181_(OptionalInt.of($$14 - 1));
                    pLevel.m_7731_(pPos.m_175288_($$14), Blocks.f_49990_.m_49966_(), 2);
                } else {
                    $$16 = (Column)$$10.get();
                }
                OptionalInt $$17 = $$16.m_142009_();
                boolean bl2 = $$18 = pRandom.m_188500_() < pChance;
                if ($$11.isPresent() && $$18 && !this.isLava((LevelReader)pLevel, pPos.m_175288_($$11.getAsInt()))) {
                    $$28 = pConfig.f_160764_.m_214085_(pRandom);
                    this.replaceBlocksWithDripstoneBlocks(pLevel, pPos.m_175288_($$11.getAsInt()), $$28, Direction.UP);
                    int $$21 = $$17.isPresent() ? Math.min(pHeight, $$11.getAsInt() - $$17.getAsInt()) : pHeight;
                    $$23 = this.getDripstoneHeight(pRandom, pX, pZ, pDensity, $$21, pConfig);
                } else {
                    $$23 = 0;
                }
                boolean bl3 = $$24 = pRandom.m_188500_() < pChance;
                if ($$17.isPresent() && $$24 && !this.isLava((LevelReader)pLevel, pPos.m_175288_($$17.getAsInt()))) {
                    $$37 = pConfig.f_160764_.m_214085_(pRandom);
                    this.replaceBlocksWithDripstoneBlocks(pLevel, pPos.m_175288_($$17.getAsInt()), $$37, Direction.DOWN);
                    $$28 = $$11.isPresent() ? Math.max(0, $$23 + Mth.m_216287_((RandomSource)pRandom, (int)(-pConfig.f_160762_), (int)pConfig.f_160762_)) : this.getDripstoneHeight(pRandom, pX, pZ, pDensity, pHeight, pConfig);
                } else {
                    $$28 = 0;
                }
                if ($$11.isPresent() && $$17.isPresent() && $$11.getAsInt() - $$23 <= $$17.getAsInt() + $$28) {
                    int $$29 = $$17.getAsInt();
                    int $$30 = $$11.getAsInt();
                    int $$31 = Math.max($$30 - $$23, $$29 + 1);
                    int $$32 = Math.min($$29 + $$28, $$30 - 1);
                    int $$33 = Mth.m_216287_((RandomSource)pRandom, (int)$$31, (int)($$32 + 1));
                    int $$34 = $$33 - 1;
                    $$37 = $$30 - $$33;
                    $$38 = $$34 - $$29;
                } else {
                    $$37 = $$23;
                    $$38 = $$28;
                }
                boolean bl4 = $$39 = pRandom.m_188499_() && $$37 > 0 && $$38 > 0 && $$16.m_142030_().isPresent() && $$37 + $$38 == $$16.m_142030_().getAsInt();
                if ($$11.isPresent()) {
                    BlackIceClusterFeature.growBlackIcicle((LevelAccessor)pLevel, pPos.m_175288_($$11.getAsInt() - 1), Direction.DOWN, $$37, $$39);
                }
                if ($$17.isPresent()) {
                    BlackIceClusterFeature.growBlackIcicle((LevelAccessor)pLevel, pPos.m_175288_($$17.getAsInt() + 1), Direction.UP, $$38, $$39);
                }
            }
        }
    }

    private boolean isLava(LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos).m_60713_(Blocks.f_49991_);
    }

    private int getDripstoneHeight(RandomSource pRandom, int pX, int pZ, float pChance, int pHeight, DripstoneClusterConfiguration pConfig) {
        if (pRandom.m_188501_() > pChance) {
            return 0;
        }
        int $$6 = Math.abs(pX) + Math.abs(pZ);
        float $$7 = (float)Mth.m_144851_((double)$$6, (double)0.0, (double)pConfig.f_160769_, (double)((double)pHeight / 2.0), (double)0.0);
        return (int)BlackIceClusterFeature.randomBetweenBiased(pRandom, 0.0f, pHeight, $$7, pConfig.f_160763_);
    }

    private boolean canPlacePool(WorldGenLevel pLevel, BlockPos pPos) {
        BlockState $$2 = pLevel.m_8055_(pPos);
        if (!($$2.m_60713_(Blocks.f_49990_) || $$2.m_60713_((Block)JNEBlocks.BLACK_ICE.get()) || $$2.m_60713_((Block)JNEBlocks.BLACK_ICICLE.get()) || pLevel.m_8055_(pPos.m_7494_()).m_60819_().m_205070_(FluidTags.f_13131_))) {
            Direction $$3;
            Iterator var4 = Direction.Plane.HORIZONTAL.iterator();
            do {
                if (var4.hasNext()) continue;
                return this.canBeAdjacentToWater((LevelAccessor)pLevel, pPos.m_7495_());
            } while (this.canBeAdjacentToWater((LevelAccessor)pLevel, pPos.m_121945_($$3 = (Direction)var4.next())));
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor pLevel, BlockPos pPos) {
        BlockState $$2 = pLevel.m_8055_(pPos);
        return $$2.m_204336_(BlockTags.f_13061_) || $$2.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    private void replaceBlocksWithDripstoneBlocks(WorldGenLevel pLevel, BlockPos pPos, int pThickness, Direction pDirection) {
        BlockPos.MutableBlockPos $$4 = pPos.m_122032_();
        for (int $$5 = 0; $$5 < pThickness; ++$$5) {
            if (!BlackIceClusterFeature.placeBlackIceIfPossible((LevelAccessor)pLevel, (BlockPos)$$4)) {
                return;
            }
            $$4.m_122173_(pDirection);
        }
    }

    protected static boolean placeBlackIceIfPossible(LevelAccessor pLevel, BlockPos pPos) {
        BlockState $$2 = pLevel.m_8055_(pPos);
        if ($$2.m_204336_(JNETags.Blocks.BLACK_ICE_REPLACEABLE)) {
            pLevel.m_7731_(pPos, ((Block)JNEBlocks.BLACK_ICE.get()).m_49966_(), 2);
            return true;
        }
        return false;
    }

    private double getChanceOfStalagmiteOrStalactite(int pXRadius, int pZRadius, int pX, int pZ, DripstoneClusterConfiguration pConfig) {
        int $$5 = pXRadius - Math.abs(pX);
        int $$6 = pZRadius - Math.abs(pZ);
        int $$7 = Math.min($$5, $$6);
        return Mth.m_184631_((float)$$7, (float)0.0f, (float)pConfig.f_160768_, (float)pConfig.f_160767_, (float)1.0f);
    }

    private static float randomBetweenBiased(RandomSource pRandom, float pMin, float pMax, float pMean, float pDeviation) {
        return ClampedNormalFloat.m_216837_((RandomSource)pRandom, (float)pMean, (float)pDeviation, (float)pMin, (float)pMax);
    }

    protected static boolean isEmptyOrWater(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, DripstoneUtils::m_159664_);
    }

    protected static void growBlackIcicle(LevelAccessor pLevel, BlockPos pPos, Direction pDirection, int pHeight, boolean pMergeTip) {
        if (BlackIceClusterFeature.isBlackIceBaseOrLava(pLevel.m_8055_(pPos.m_121945_(pDirection.m_122424_())))) {
            BlockPos.MutableBlockPos $$5 = pPos.m_122032_();
            BlackIceClusterFeature.buildBaseToTipColumn(pDirection, pHeight, pMergeTip, p_277326_ -> {
                if (p_277326_.m_60713_((Block)JNEBlocks.BLACK_ICICLE.get())) {
                    p_277326_ = (BlockState)p_277326_.m_61124_((Property)PointedDripstoneBlock.f_154011_, (Comparable)Boolean.valueOf(pLevel.m_46801_((BlockPos)$$5)));
                }
                pLevel.m_7731_((BlockPos)$$5, p_277326_, 2);
                $$5.m_122173_(pDirection);
            });
        }
    }

    public static boolean isBlackIceBaseOrLava(BlockState pState) {
        return BlackIceClusterFeature.isBlackIceBase(pState) || pState.m_60713_(Blocks.f_49991_);
    }

    public static boolean isBlackIceBase(BlockState pState) {
        return pState.m_60713_((Block)JNEBlocks.BLACK_ICE.get()) || pState.m_204336_(JNETags.Blocks.BLACK_ICE_REPLACEABLE);
    }

    protected static void buildBaseToTipColumn(Direction pDirection, int pHeight, boolean pMergeTip, Consumer<BlockState> pBlockSetter) {
        if (pHeight >= 3) {
            pBlockSetter.accept(BlackIceClusterFeature.createBlackIcicle(pDirection, DripstoneThickness.BASE));
            for (int $$4 = 0; $$4 < pHeight - 3; ++$$4) {
                pBlockSetter.accept(BlackIceClusterFeature.createBlackIcicle(pDirection, DripstoneThickness.MIDDLE));
            }
        }
        if (pHeight >= 2) {
            pBlockSetter.accept(BlackIceClusterFeature.createBlackIcicle(pDirection, DripstoneThickness.FRUSTUM));
        }
        if (pHeight >= 1) {
            pBlockSetter.accept(BlackIceClusterFeature.createBlackIcicle(pDirection, pMergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    private static BlockState createBlackIcicle(Direction pDirection, DripstoneThickness pDripstoneThickness) {
        return (BlockState)((BlockState)((Block)JNEBlocks.BLACK_ICICLE.get()).m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)pDirection)).m_61124_((Property)PointedDripstoneBlock.f_154010_, (Comparable)pDripstoneThickness);
    }
}

