/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.loot.custom;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ReplaceItemModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("target_item").forGetter(m -> m.targetItem)).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("replacement_item").forGetter(m -> m.replacementItem)).apply((Applicative)inst, ReplaceItemModifier::new)));
    private final Item targetItem;
    private final Item replacementItem;

    public ReplaceItemModifier(LootItemCondition[] conditionsIn, Item targetItem, Item replacementItem) {
        super(conditionsIn);
        this.targetItem = targetItem;
        this.replacementItem = replacementItem;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        for (int i = 0; i < generatedLoot.size(); ++i) {
            ItemStack stack = (ItemStack)generatedLoot.get(i);
            if (stack.m_41720_() != this.targetItem) continue;
            ItemStack replacementStack = new ItemStack((ItemLike)this.replacementItem, stack.m_41613_());
            generatedLoot.set(i, (Object)replacementStack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

