/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.loot.custom;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddEnchantedItemModifier
extends LootModifier {
    public static final Supplier<Codec<AddEnchantedItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddEnchantedItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)ForgeRegistries.ENCHANTMENTS.getCodec().fieldOf("enchantment").forGetter(m -> m.enchantment), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(m -> m.count), (App)Codec.INT.optionalFieldOf("min_level", (Object)1).forGetter(m -> m.minLevel), (App)Codec.INT.optionalFieldOf("max_level", (Object)1).forGetter(m -> m.maxLevel))).apply((Applicative)inst, AddEnchantedItemModifier::new)));
    private final Item item;
    private final Enchantment enchantment;
    private final int count;
    private final int minLevel;
    private final int maxLevel;

    protected AddEnchantedItemModifier(LootItemCondition[] conditionsIn, Item item, Enchantment enchantment, int count, int minLevel, int maxLevel) {
        super(conditionsIn);
        this.item = item;
        this.enchantment = enchantment;
        this.count = count;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
        int level = Mth.m_216271_((RandomSource)context.m_230907_(), (int)this.minLevel, (int)this.maxLevel);
        EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(this.enchantment, level));
        if (stack.m_41613_() < stack.m_41741_()) {
            generatedLoot.add((Object)stack);
        } else {
            ItemStack subStack;
            for (int i = stack.m_41613_(); i > 0; i -= subStack.m_41613_()) {
                subStack = stack.m_41777_();
                subStack.m_41764_(Math.min(stack.m_41741_(), i));
                generatedLoot.add((Object)subStack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

