/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.item.custom;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jadenxgamer.elysium_api.api.keyframe.NonEntityAnimationState;
import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.jadenxgamer.netherexp.registry.enchantment.JNEEnchantments;
import net.jadenxgamer.netherexp.registry.entity.custom.SoulBullet;
import net.jadenxgamer.netherexp.registry.item.JNEItemRenderer;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.item.custom.IShotgun;
import net.jadenxgamer.netherexp.registry.misc_registry.JNEDamageSources;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class PumpChargeShotgunItem
extends ProjectileWeaponItem
implements Vanishable,
IShotgun {
    public final NonEntityAnimationState fireAnimationState = new NonEntityAnimationState();
    public final NonEntityAnimationState pumpAnimationState = new NonEntityAnimationState();
    public final NonEntityAnimationState overpumpAnimationState = new NonEntityAnimationState();
    private int pumpTimeOut;
    private boolean pumpFlag;
    private int fireTimeOut;
    private boolean fireFlag;

    public PumpChargeShotgunItem(Item.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new JNEItemRenderer();
            }
        });
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        if (level.m_5776_()) {
            if (this.pumpFlag) {
                this.playPumpAnimation(player, player.f_19797_);
            }
            if (this.fireFlag) {
                this.playFireAnimation(player, player.f_19797_);
            }
            if (PumpChargeShotgunItem.getCharge(stack) >= 4) {
                this.overpumpAnimationState.startIfStopped(player.f_19797_, (Entity)player);
            } else {
                this.overpumpAnimationState.stop((Entity)player);
            }
        }
    }

    private void useProjectile(ItemStack stack, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            boolean creative = player.m_150110_().f_35937_;
            ItemStack projectileStack = player.m_6298_(stack);
            if (!projectileStack.m_41619_() || creative) {
                boolean bl;
                if (projectileStack.m_41619_()) {
                    projectileStack = new ItemStack((ItemLike)JNEItems.WRAITHING_FLESH.get());
                }
                boolean bl2 = bl = projectileStack.m_41720_() == JNEItems.WRAITHING_FLESH.get();
                if (bl && !creative) {
                    projectileStack.m_41774_(1);
                    if (projectileStack.m_41619_()) {
                        player.m_150109_().m_36057_(projectileStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        int cartridge = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)JNEEnchantments.CARTRIDGE.get()), (ItemStack)stack);
        if (player.m_6144_()) {
            if (PumpChargeShotgunItem.getCharge(stack) <= 3) {
                PumpChargeShotgunItem.setCharge(stack, PumpChargeShotgunItem.getCharge(stack) + 1);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)JNESoundEvents.SHOTGUN_LOAD.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (PumpChargeShotgunItem.getCharge(stack) <= 3) {
            if (!player.m_6298_(stack).m_41619_() || player.m_150110_().f_35937_) {
                this.performShooting(level, (LivingEntity)player, stack);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)JNESoundEvents.SHOTGUN_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_36335_().m_41524_((Item)this, 15);
                if (cartridge > 0 && level.f_46441_.m_188503_(1 + cartridge) == 0) {
                    this.useProjectile(stack, (LivingEntity)player);
                } else {
                    this.useProjectile(stack, (LivingEntity)player);
                }
                PumpChargeShotgunItem.setCharge(stack, 0);
                this.fireFlag = true;
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        } else if (!player.m_6298_(stack).m_41619_() || player.m_150110_().f_35937_) {
            this.performShooting(level, (LivingEntity)player, stack);
            level.m_255391_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), 3.0f, false, Level.ExplosionInteraction.NONE);
            player.m_36335_().m_41524_((Item)this, 100);
            player.m_6469_(level.m_269111_().m_269298_(JNEDamageSources.SHOTGUN_EXPLOSION, (Entity)player), 10.0f);
            stack.m_41622_(5, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            if (cartridge > 0 && level.f_46441_.m_188503_(cartridge) == 0) {
                this.useProjectile(stack, (LivingEntity)player);
            } else {
                this.useProjectile(stack, (LivingEntity)player);
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)JNESoundEvents.SHOTGUN_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            PumpChargeShotgunItem.setCharge(stack, 0);
            this.fireFlag = true;
            Vec3 look = player.m_20154_();
            Vec3 pushBack = new Vec3(-look.f_82479_, -look.f_82480_, -look.f_82481_).m_82541_();
            player.m_5997_(pushBack.f_82479_ * 1.75, pushBack.f_82480_ * 1.75, pushBack.f_82481_ * 1.75);
            List nearbyEntities = level.m_45933_((Entity)player, new AABB(player.m_20097_()).m_82377_(5.0, 5.0, 5.0));
            if (nearbyEntities.stream().filter(entity -> entity instanceof Mob).filter(entity -> ((Mob)entity).m_21224_()).count() >= 10L && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                JNECriteriaTriggers.KILLED_WITH_PUMP_CHARGE.m_222618_(serverPlayer);
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void performShooting(Level level, LivingEntity user, ItemStack stack) {
        LivingEntity livingEntity;
        Entity entity2;
        AABB aabb;
        Vec3 raycastEnd;
        Vec3 raycastStart;
        EntityHitResult entityHitResult;
        int chargeCount = PumpChargeShotgunItem.getCharge(stack) * 6;
        int chargeInaccuracy = PumpChargeShotgunItem.getCharge(stack) * 8;
        int recoil = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)JNEEnchantments.RECOIL.get()), (ItemStack)stack);
        int artemis = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)JNEEnchantments.ARTEMIS.get()), (ItemStack)stack);
        int aBulletDistanceBonus = artemis / 5;
        double recoilPushBonus = (double)recoil / 16.0;
        double chargePushBonus = (double)PumpChargeShotgunItem.getCharge(stack) / 10.0;
        Vec3 look = user.m_20154_();
        Vec3 pushBack = new Vec3(-look.f_82479_, -look.f_82480_, -look.f_82481_).m_82541_();
        int maxCount = 4 + chargeCount;
        int minCount = Math.max(1, 4 + PumpChargeShotgunItem.getCharge(stack) / 2);
        int count = Math.max(minCount, maxCount);
        if (!level.f_46443_) {
            for (int i = 0; i < count; ++i) {
                SoulBullet soulBullet = new SoulBullet(level, user);
                soulBullet.m_6686_(look.f_82479_, look.f_82480_, look.f_82481_, 1.0f + (float)aBulletDistanceBonus, 5 + chargeInaccuracy);
                level.m_7967_((Entity)soulBullet);
            }
        }
        if ((entityHitResult = ProjectileUtil.m_37304_((Level)level, (Entity)user, (Vec3)(raycastStart = user.m_20299_(1.0f)), (Vec3)(raycastEnd = raycastStart.m_82549_(user.m_20252_(1.0f).m_82490_(5.0))), (AABB)(aabb = new AABB(raycastStart, raycastEnd)), entity -> entity instanceof LivingEntity && entity != user)) != null && (entity2 = entityHitResult.m_82443_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).m_6084_()) {
            user.m_5997_(pushBack.f_82479_ * (0.75 + recoilPushBonus + chargePushBonus), pushBack.f_82480_ * (0.75 + recoilPushBonus + chargePushBonus), pushBack.f_82481_ * (0.75 + recoilPushBonus + chargePushBonus));
        } else {
            user.m_5997_(pushBack.f_82479_ * (0.3 + recoilPushBonus + chargePushBonus), pushBack.f_82480_ * (0.3 + recoilPushBonus + chargePushBonus), pushBack.f_82481_ * (0.3 + recoilPushBonus + chargePushBonus));
        }
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_150930_((Item)JNEItems.WRAITHING_FLESH.get());
    }

    public int m_6615_() {
        return 15;
    }

    public static int getCharge(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128451_("Charge");
    }

    public static void setCharge(ItemStack stack, int i) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_("Charge", i);
    }

    private void playPumpAnimation(Player player, int tickCount) {
        if (this.pumpTimeOut == 20) {
            this.pumpAnimationState.startIfStopped(tickCount, (Entity)player);
        }
        if (this.pumpTimeOut > 0) {
            --this.pumpTimeOut;
        }
        if (this.pumpTimeOut <= 0) {
            this.pumpAnimationState.stop((Entity)player);
            this.pumpTimeOut = 20;
            this.pumpFlag = false;
        }
    }

    private void playFireAnimation(Player player, int tickCount) {
        if (this.fireTimeOut == 20) {
            this.fireAnimationState.startIfStopped(tickCount, (Entity)player);
        }
        if (this.fireTimeOut > 0) {
            --this.fireTimeOut;
        }
        if (this.fireTimeOut <= 0) {
            this.fireAnimationState.stop((Entity)player);
            this.fireTimeOut = 20;
            this.fireFlag = false;
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)JNEItems.PUMP_CHARGE_SHOTGUN.get()) || !newStack.m_150930_((Item)JNEItems.PUMP_CHARGE_SHOTGUN.get());
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepair) {
        return pRepair.m_150930_((Item)JNEItems.STRIDITE.get()) || super.m_6832_(pStack, pRepair);
    }
}

