/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.item.custom;

import java.util.function.Supplier;
import net.jadenxgamer.netherexp.registry.entity.custom.Bottleable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class MobBottleItem<T extends Entity>
extends Item {
    private final Supplier<EntityType<T>> entityType;
    private final SoundEvent soundEvent;

    public MobBottleItem(Supplier<EntityType<T>> entityType, SoundEvent soundEvent, Item.Properties properties) {
        super(properties);
        this.entityType = entityType;
        this.soundEvent = soundEvent;
    }

    public EntityType<?> getEntityType() {
        return this.entityType.get();
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = MobBottleItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos pos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos relativePos = pos.m_121945_(direction);
        if (level.m_7966_(player, pos) && player.m_36204_(relativePos, direction, itemStack)) {
            level.m_5594_(player, relativePos, this.getSoundEvent(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                Entity entity = this.getEntityType().m_20592_((ServerLevel)level, itemStack, null, relativePos, MobSpawnType.BUCKET, true, false);
                if (entity instanceof Bottleable) {
                    Bottleable bottleable = (Bottleable)entity;
                    bottleable.loadFromBottleTag(itemStack.m_41784_());
                    bottleable.setFromBottle(true);
                }
                level.m_142346_((Entity)player, GameEvent.f_157810_, relativePos);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)MobBottleItem.getEmptySuccessItem(itemStack, player), (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack itemStack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42590_) : itemStack;
    }
}

