/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.item.custom;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jadenxgamer.elysium_api.api.keyframe.NonEntityAnimationState;
import net.jadenxgamer.elysium_api.api.util.ResourceKeyRegistryHelper;
import net.jadenxgamer.netherexp.NetherExp;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.enchantment.JNEEnchantments;
import net.jadenxgamer.netherexp.registry.item.JNEItemRenderer;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.item.custom.IShotgun;
import net.jadenxgamer.netherexp.registry.misc_registry.JNEDamageSources;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class JackhammerFistItem
extends ProjectileWeaponItem
implements Vanishable,
IShotgun {
    public final NonEntityAnimationState punchAnimationState = new NonEntityAnimationState();
    public final NonEntityAnimationState pullAnimationState = new NonEntityAnimationState();
    public final NonEntityAnimationState pullLoopAnimationState = new NonEntityAnimationState();
    private int pullTimeOut;
    private boolean pullFlag;
    private int punchTimeOut;
    private boolean punchFlag;

    public JackhammerFistItem(Item.Properties properties) {
        super(properties);
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        if (level.m_5776_()) {
            if (this.pullFlag) {
                this.playPullAnimation(player, player.f_19797_);
            }
            if (this.punchFlag) {
                this.playFireAnimation(player, player.f_19797_);
            }
            if (JackhammerFistItem.getPulled(stack)) {
                this.pullLoopAnimationState.startIfStopped(player.f_19797_, (Entity)player);
            } else {
                this.pullLoopAnimationState.stop((Entity)player);
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new JNEItemRenderer();
            }
        });
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6298_(stack).m_41619_() || player.m_150110_().f_35937_) {
            this.pullFlag = true;
            this.pullTimeOut = 20;
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int count) {
        int ticksUsed = pStack.m_41779_() - count;
        if (ticksUsed >= 20 && !JackhammerFistItem.getPulled(pStack)) {
            JackhammerFistItem.setPulled(pStack, true);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int useCount) {
        int ticksUsed = stack.m_41779_() - useCount;
        if (ticksUsed >= 20) {
            int recoil = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)JNEEnchantments.RECOIL.get()), (ItemStack)stack);
            JackhammerFistItem.setPulled(stack, false);
            this.punchFlag = true;
            this.useProjectile(stack, user);
            Vec3 look = user.m_20154_();
            Vec3 pushBack = new Vec3(-look.f_82479_, -look.f_82480_, -look.f_82481_).m_82541_();
            double recoilPushBonus = (double)recoil / 16.0;
            Vec3 velocity = user.m_20184_();
            double horizontalSpeed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
            float damage = (float)Math.min(8.0 + horizontalSpeed * 64.0, JNEConfigs.JACKHAMMER_FIST_MAX_DAMAGE.get());
            double speedPushBonus = 0.1 + horizontalSpeed;
            if (JNEConfigs.DEV_TEST_MODE.get().booleanValue()) {
                NetherExp.LOGGER.info("Jackhammer-Fist Calculated Damage: {} for Velocity: {}", (Object)Float.valueOf(damage), (Object)horizontalSpeed);
            }
            Vec3 raycastStart = user.m_20299_(1.0f);
            Vec3 raycastEnd = raycastStart.m_82549_(user.m_20252_(1.0f).m_82490_(5.0));
            AABB aabb = new AABB(raycastStart, raycastEnd).m_82377_(1.3, 1.3, 0.0);
            List entities = level.m_6249_((Entity)user, aabb, EntitySelector.f_20406_);
            for (Entity entity : entities) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!level.m_5776_()) {
                        livingEntity.m_6469_(user.m_9236_().m_269111_().m_269298_(JNEDamageSources.JACKHAMMER, (Entity)user), damage);
                    }
                }
                int particleCount = (int)(1.0 + horizontalSpeed * 16.0);
                for (int i = 0; i < particleCount; ++i) {
                    ParticleType particle = ResourceKeyRegistryHelper.getParticleType((ResourceLocation)new ResourceLocation("oreganized", "kinetic_hit"));
                    if (!(particle instanceof SimpleParticleType)) continue;
                    SimpleParticleType simpleParticleType = (SimpleParticleType)particle;
                    level.m_7106_((ParticleOptions)simpleParticleType, entity.m_20208_(0.75), entity.m_20187_(), entity.m_20262_(0.75), level.f_46441_.m_188583_() * 0.02, level.f_46441_.m_188583_() * 0.02, level.f_46441_.m_188583_() * 0.02);
                }
            }
            user.m_5997_(pushBack.f_82479_ * (0.5 + recoilPushBonus + speedPushBonus), pushBack.f_82480_ * (0.5 + recoilPushBonus + speedPushBonus), pushBack.f_82481_ * (0.5 + recoilPushBonus + speedPushBonus));
            level.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)JNESoundEvents.SHOTGUN_USE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public int m_6615_() {
        return 15;
    }

    private void useProjectile(ItemStack stack, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            boolean creative = player.m_150110_().f_35937_;
            ItemStack projectileStack = player.m_6298_(stack);
            if (!projectileStack.m_41619_() || creative) {
                boolean bl;
                if (projectileStack.m_41619_()) {
                    projectileStack = new ItemStack((ItemLike)JNEItems.WRAITHING_FLESH.get());
                }
                boolean bl2 = bl = projectileStack.m_41720_() == JNEItems.WRAITHING_FLESH.get();
                if (bl && !creative) {
                    projectileStack.m_41774_(1);
                    if (projectileStack.m_41619_()) {
                        player.m_150109_().m_36057_(projectileStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    private void playPullAnimation(Player player, int tickCount) {
        if (this.pullTimeOut == 20) {
            this.pullAnimationState.startIfStopped(tickCount, (Entity)player);
        }
        if (this.pullTimeOut > 0) {
            --this.pullTimeOut;
        }
        if (this.pullTimeOut <= 0) {
            this.pullAnimationState.stop((Entity)player);
            this.pullTimeOut = 20;
            this.pullFlag = false;
        }
    }

    private void playFireAnimation(Player player, int tickCount) {
        if (this.punchTimeOut == 20) {
            this.punchAnimationState.startIfStopped(tickCount, (Entity)player);
        }
        if (this.punchTimeOut > 0) {
            --this.punchTimeOut;
        }
        if (this.punchTimeOut <= 0) {
            this.punchAnimationState.stop((Entity)player);
            this.punchTimeOut = 20;
            this.punchFlag = false;
        }
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_150930_((Item)JNEItems.WRAITHING_FLESH.get());
    }

    public static boolean getPulled(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128471_("Pulled");
    }

    public static void setPulled(ItemStack stack, boolean bl) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128379_("Pulled", bl);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)JNEItems.JACKHAMMER_FIST.get()) || !newStack.m_150930_((Item)JNEItems.JACKHAMMER_FIST.get());
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepair) {
        return pRepair.m_150930_((Item)JNEItems.STRIDITE.get()) || super.m_6832_(pStack, pRepair);
    }
}

