/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntidoteItem
extends Item {
    public AntidoteItem(Item.Properties properties) {
        super(properties);
    }

    private static MobEffect getAntidoteEffect(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("AntidoteEffect") || Objects.equals(nbt.m_128461_("Antidote"), "Awkward")) {
            return null;
        }
        ResourceLocation antidoteLocation = new ResourceLocation(stack.m_41784_().m_128461_("AntidoteEffect"));
        return Objects.requireNonNull((MobEffect)BuiltInRegistries.f_256974_.m_7745_(antidoteLocation));
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        MobEffect antidoteEffect;
        Player playerEntity = user instanceof Player ? (Player)user : null;
        CompoundTag nbt = stack.m_41784_();
        if (playerEntity instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)playerEntity, stack);
        }
        if (!level.f_46443_ && (antidoteEffect = AntidoteItem.getAntidoteEffect(stack)) != null && !nbt.m_128471_("Inactive")) {
            user.m_7292_(new MobEffectInstance(Objects.requireNonNull(AntidoteItem.getAntidoteEffect(stack)), AntidoteItem.getDuration(stack), 0));
        }
        if (playerEntity != null) {
            playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!playerEntity.m_150110_().f_35937_) {
                stack.m_41774_(1);
                level.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
        user.m_146850_(GameEvent.f_223704_);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        MobEffect antidoteEffect = AntidoteItem.getAntidoteEffect(stack);
        CompoundTag nbt = stack.m_41784_();
        if (antidoteEffect != null && nbt.m_128471_("Inactive")) {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"item.netherexp.antidote.inactive_tooltip").m_130940_(ChatFormatting.DARK_PURPLE));
            tooltip.add((Component)Component.m_237115_((String)antidoteEffect.m_19481_()).m_130940_(ChatFormatting.BLUE));
        } else if (antidoteEffect != null) {
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
            list.add(new MobEffectInstance(Objects.requireNonNull(AntidoteItem.getAntidoteEffect(stack)), AntidoteItem.getDuration(stack), 0));
            PotionUtils.m_257410_(list, tooltip, (float)1.0f);
        } else {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static int getColor(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        MobEffect antidoteEffect = AntidoteItem.getAntidoteEffect(stack);
        if (nbt.m_128441_("CustomAntidoteColor")) {
            return nbt.m_128451_("CustomAntidoteColor");
        }
        return antidoteEffect == null ? 0xF800F8 : antidoteEffect.m_19484_();
    }

    public static int getDuration(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("Duration")) {
            return nbt.m_128451_("Duration") * 20;
        }
        return 36000;
    }

    @NotNull
    public String m_5671_(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128461_("Antidote");
        return this.m_5524_() + ".effect." + nbt.m_128461_("Antidote");
    }

    public int m_8105_(ItemStack stack) {
        return 48;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand);
    }
}

