/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.fluid.custom;

import java.util.function.Consumer;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class EctoplasmFluidType
extends FluidType {
    private static final ResourceLocation STILL = new ResourceLocation("netherexp:block/ectoplasm_still");
    private static final ResourceLocation FLOWING = new ResourceLocation("netherexp:block/ectoplasm_flow");
    private static final ResourceLocation OVERLAY = new ResourceLocation("netherexp:textures/block/ectoplasm_overlay.png");

    public EctoplasmFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return OVERLAY;
            }
        });
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        return false;
    }

    public void onVaporize(@Nullable Player player, Level level, BlockPos pos, FluidStack stack) {
        level.m_5594_(player, pos, (SoundEvent)JNESoundEvents.ECTOPLASM_FREEZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        for (int l = 0; l < 8; ++l) {
            level.m_7107_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

