/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Apparition;
import net.jadenxgamer.netherexp.registry.entity.custom.SoulBullet;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vessel
extends Monster
implements RangedAttackMob {
    private int changeType = 1;
    boolean isShotgunGuy;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState aimAnimationState = new AnimationState();
    public final AnimationState aimIdleAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState blinkAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private static final EntityDataAccessor<Boolean> PREPARING_AIM = SynchedEntityData.m_135353_(Vessel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_AIMING = SynchedEntityData.m_135353_(Vessel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(Vessel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Vessel(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.getPreparingAim()) {
            this.aimAnimationState.m_216982_(this.f_19797_);
        } else {
            this.aimAnimationState.m_216973_();
        }
        if (this.getIsAiming()) {
            this.aimIdleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.aimIdleAnimationState.m_216973_();
        }
        if (this.getShoot()) {
            this.shootAnimationState.m_216982_(this.f_19797_);
        } else {
            this.shootAnimationState.m_216973_();
            if (this.f_19796_.m_188503_(8) == 0) {
                this.blinkAnimationState.m_216982_(this.f_19797_);
            }
        }
    }

    protected void m_267689_(float v) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void m_8107_() {
        if (this.m_20070_()) {
            if (this.getChangeType() == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.m_146870_();
            } else {
                this.doExorcism();
            }
        }
        super.m_8107_();
    }

    public boolean m_6126_() {
        return true;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new VesselAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        SoundEvent fireSound = this.isShotgunGuy ? (SoundEvent)JNESoundEvents.ENTITY_SHOTGUN_GUY_FIRE.get() : (SoundEvent)JNESoundEvents.ENTITY_VESSEL_FIRE.get();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), fireSound, this.m_5720_(), 1.0f, 1.0f);
        int count = Mth.m_216271_((RandomSource)this.m_9236_().f_46441_, (int)16, (int)20);
        Vec3 look = this.m_20154_();
        double d0 = livingEntity.m_20185_() - this.m_20185_();
        double d2 = livingEntity.m_20189_() - this.m_20189_();
        for (int i = 0; i < count; ++i) {
            SoulBullet soulBullet = new SoulBullet(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), this.m_9236_(), (LivingEntity)this);
            soulBullet.m_6686_(d0, look.f_82480_, d2, 1.0f, 16.0f);
            this.m_9236_().m_7967_((Entity)soulBullet);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        ThrownPotion thrownPotion;
        Entity entity = damageSource.m_7640_();
        if (entity instanceof ThrownPotion && this.hurtWithCleanWater(thrownPotion = (ThrownPotion)entity) && this.getChangeType() > 0) {
            this.doExorcism();
            Entity entity2 = thrownPotion.m_19749_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                JNECriteriaTriggers.EXORCISM.m_222618_((ServerPlayer)player);
            }
        }
        return super.m_6469_(damageSource, f);
    }

    private void doExorcism() {
        Level level;
        Skeleton skeleton = (Skeleton)this.m_21406_(EntityType.f_20524_, false);
        if (skeleton != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            skeleton.m_6518_((ServerLevelAccessor)serverLevel, this.m_9236_().m_6436_(skeleton.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
            skeleton.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            skeleton.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
            skeleton.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
            if (this.m_8077_()) {
                skeleton.m_6593_(skeleton.m_7770_());
            }
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)JNEParticleTypes.WISP.get(), this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
        }
    }

    private boolean hurtWithCleanWater(ThrownPotion thrownPotion) {
        ItemStack itemStack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        return potion == Potions.f_43599_ && list.isEmpty();
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        int escapingOdds = this.f_19796_.m_188503_(this.m_9236_().m_46791_() == Difficulty.HARD ? 1 : 3);
        if (this.m_9236_().m_46791_() != Difficulty.EASY && escapingOdds == 0) {
            Apparition apparition = (Apparition)((EntityType)JNEEntityType.APPARITION.get()).m_20615_(this.m_9236_());
            if (apparition != null) {
                apparition.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                apparition.setCooldown(1200);
                apparition.setPreference(1);
                if (this.m_5448_() != null) {
                    apparition.m_6710_(this.m_5448_());
                }
            }
            this.m_9236_().m_7967_((Entity)apparition);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PREPARING_AIM, (Object)false);
        this.m_20088_().m_135372_(IS_AIMING, (Object)false);
        this.m_20088_().m_135372_(SHOOT, (Object)false);
    }

    private boolean getPreparingAim() {
        return (Boolean)this.m_20088_().m_135370_(PREPARING_AIM);
    }

    private void setPreparingAim(boolean bl) {
        this.m_20088_().m_135381_(PREPARING_AIM, (Object)bl);
    }

    private boolean getIsAiming() {
        return (Boolean)this.m_20088_().m_135370_(IS_AIMING);
    }

    private void setIsAiming(boolean bl) {
        this.m_20088_().m_135381_(IS_AIMING, (Object)bl);
    }

    private boolean getShoot() {
        return (Boolean)this.m_20088_().m_135370_(SHOOT);
    }

    private void setShoot(boolean bl) {
        this.m_20088_().m_135381_(SHOOT, (Object)bl);
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("ChangeType", this.getChangeType());
        if (this.isShotgunGuy) {
            nbt.m_128379_("ShotgunGuy", true);
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setChangeType(nbt.m_128451_("ChangeType"));
        if (nbt.m_128425_("ShotgunGuy", 99)) {
            this.isShotgunGuy = nbt.m_128471_("ShotgunGuy");
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (!this.isShotgunGuy && name != null && name.getString().equals("ShotgunGuy") || name.getString().equals("Shotgun Guy") || name.getString().equals("DOOM")) {
            this.isShotgunGuy = true;
        }
    }

    protected SoundEvent m_7515_() {
        return this.isShotgunGuy ? (SoundEvent)JNESoundEvents.ENTITY_SHOTGUN_GUY_AMBIENT.get() : (SoundEvent)JNESoundEvents.ENTITY_VESSEL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.isShotgunGuy ? (SoundEvent)JNESoundEvents.ENTITY_SHOTGUN_GUY_HURT.get() : (SoundEvent)JNESoundEvents.ENTITY_VESSEL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.isShotgunGuy ? (SoundEvent)JNESoundEvents.ENTITY_SHOTGUN_GUY_DEATH.get() : (SoundEvent)JNESoundEvents.ENTITY_VESSEL_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    private static class VesselAttackGoal
    extends Goal {
        private final Vessel vessel;
        private int attackTime;
        private boolean finished;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime;

        public VesselAttackGoal(Vessel vessel) {
            this.vessel = vessel;
            this.attackTime = 110;
            this.strafingTime = -1;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.vessel.m_5448_();
            return livingEntity != null && livingEntity.m_6084_() && this.vessel.m_6779_(livingEntity);
        }

        public boolean m_8045_() {
            return !this.finished && super.m_8045_();
        }

        public void m_8056_() {
            this.attackTime = 110;
            super.m_8056_();
        }

        public void m_8041_() {
            this.finished = false;
            this.vessel.setShoot(false);
            this.vessel.setIsAiming(false);
            this.seeTime = 0;
            this.attackTime = 110;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.vessel.m_5448_();
            if (target != null) {
                boolean hadSightLastTick;
                boolean hasSight = this.vessel.m_21574_().m_148306_((Entity)target);
                double distance = this.vessel.m_20280_((Entity)target);
                double attackRadius = this.getFollowDistance() * this.getFollowDistance();
                boolean bl = hadSightLastTick = this.seeTime > 0;
                if (hasSight != hadSightLastTick) {
                    this.seeTime = 0;
                }
                this.seeTime = hasSight ? ++this.seeTime : --this.seeTime;
                if (!(distance > attackRadius) && this.seeTime >= 20) {
                    this.vessel.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.vessel.m_21573_().m_5624_((Entity)target, 1.0);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.vessel.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.vessel.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (distance > attackRadius * 0.75) {
                        this.strafingBackwards = false;
                    } else if (distance < attackRadius * 0.25) {
                        this.strafingBackwards = true;
                    }
                    this.vessel.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    Entity entity = this.vessel.m_275832_();
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21391_((Entity)target, 30.0f, 30.0f);
                    }
                    this.vessel.m_21391_((Entity)target, 30.0f, 30.0f);
                } else {
                    this.vessel.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                }
                if (distance < attackRadius) {
                    if (this.attackTime > 50) {
                        if (hasSight) {
                            --this.attackTime;
                        }
                    } else {
                        --this.attackTime;
                    }
                    if (this.attackTime == 100) {
                        this.vessel.setPreparingAim(true);
                    } else if (this.attackTime == 80) {
                        this.vessel.setPreparingAim(false);
                        this.vessel.setIsAiming(true);
                    } else if (this.attackTime == 70) {
                        this.vessel.m_9236_().m_5594_(null, this.vessel.m_20183_(), (SoundEvent)JNESoundEvents.ENTITY_VESSEL_WARN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    } else if (this.attackTime == 40) {
                        this.vessel.setIsAiming(false);
                        this.vessel.setShoot(true);
                        this.vessel.m_6504_(target, 1.0f);
                    } else if (this.attackTime <= 0) {
                        this.finished = true;
                    }
                }
            }
            super.m_8037_();
        }

        private double getFollowDistance() {
            return this.vessel.m_21133_(Attributes.f_22277_);
        }
    }
}

