/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.EnumSet;
import java.util.List;
import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Apparition;
import net.jadenxgamer.netherexp.registry.entity.custom.WillOWisp;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class Banshee
extends Monster {
    private int changeType = 1;
    private int attackTime;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();

    public Banshee(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 10;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.isMoving()) {
                this.walkAnimationState.m_216982_(this.f_19797_);
                this.idleAnimationState.m_216973_();
            } else {
                this.idleAnimationState.m_216982_(this.f_19797_);
                this.walkAnimationState.m_216973_();
            }
        }
    }

    private boolean isMoving() {
        return this.m_20184_().m_165924_() > (double)0.01f;
    }

    public void m_8107_() {
        if (this.m_20070_()) {
            if (this.getChangeType() == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.m_146870_();
            } else {
                this.doExorcism();
            }
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        LivingEntity target = this.m_5448_();
        if (target != null && this.m_6779_(target)) {
            this.m_20242_(true);
            if (this.f_19796_.m_188503_(40) == 0) {
                this.teleport();
            }
        } else {
            this.m_20242_(false);
        }
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22277_, 26.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BansheeAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
    }

    private void doExorcism() {
        Level level;
        Blaze blaze = (Blaze)this.m_21406_(EntityType.f_20551_, false);
        if (blaze != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blaze.m_6518_((ServerLevelAccessor)serverLevel, this.m_9236_().m_6436_(blaze.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
            blaze.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            blaze.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
            blaze.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
            if (this.m_8077_()) {
                blaze.m_6593_(blaze.m_7770_());
            }
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)JNEParticleTypes.WISP.get(), this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        WillOWisp willOWisp;
        ThrownPotion thrownPotion;
        Entity entity = damageSource.m_7640_();
        if (entity instanceof ThrownPotion && this.hurtWithCleanWater(thrownPotion = (ThrownPotion)entity) && this.getChangeType() > 0) {
            this.doExorcism();
            Entity entity2 = thrownPotion.m_19749_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                JNECriteriaTriggers.EXORCISM.m_222618_((ServerPlayer)player);
            }
        } else if (damageSource.m_7639_() instanceof LivingEntity) {
            this.teleport();
            this.attackTime = 80;
        }
        entity = damageSource.m_7639_();
        if (entity instanceof WillOWisp && (willOWisp = (WillOWisp)entity).m_19749_() == this) {
            this.m_6667_(damageSource);
        }
        return super.m_6469_(damageSource, f);
    }

    private boolean hurtWithCleanWater(ThrownPotion thrownPotion) {
        ItemStack itemStack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        return potion == Potions.f_43599_ && list.isEmpty();
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        int escapingOdds = this.f_19796_.m_188503_(this.m_9236_().m_46791_() == Difficulty.HARD ? 3 : 5);
        if (this.m_9236_().m_46791_() != Difficulty.EASY && escapingOdds == 0) {
            Apparition apparition = (Apparition)((EntityType)JNEEntityType.APPARITION.get()).m_20615_(this.m_9236_());
            if (apparition != null) {
                apparition.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                apparition.setCooldown(1200);
                apparition.setPreference(4);
                if (this.m_5448_() != null) {
                    apparition.m_6710_(this.m_5448_());
                }
            }
            this.m_9236_().m_7967_((Entity)apparition);
        }
    }

    protected boolean teleport() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 12.0;
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 12.0;
            return this.teleport(x, this.m_20186_(), z);
        }
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos targetPos = new BlockPos((int)x, (int)y - 1, (int)z);
        BlockState state = this.m_9236_().m_8055_(targetPos);
        boolean isSolidGround = state.m_280555_();
        boolean isLava = state.m_60819_().m_205070_(FluidTags.f_13132_);
        if (isSolidGround && !isLava) {
            boolean teleport = this.m_20984_(x, y, z, true);
            if (teleport) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)JNESoundEvents.ENTITY_BANSHEE_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_BANSHEE_TELEPORT.get(), 1.0f, 1.0f);
                }
            }
            return teleport;
        }
        return false;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
        this.f_19789_ = 0.0f;
    }

    public boolean m_6126_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JNESoundEvents.ENTITY_BANSHEE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JNESoundEvents.ENTITY_BANSHEE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)JNESoundEvents.ENTITY_BANSHEE_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_APPARITION_FLY.get(), 0.15f, 1.0f);
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("ChangeType", this.getChangeType());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setChangeType(nbt.m_128451_("ChangeType"));
    }

    static class BansheeAttackGoal
    extends Goal {
        private final Banshee banshee;

        public BansheeAttackGoal(Banshee banshee) {
            this.banshee = banshee;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.banshee.m_5448_();
            return livingEntity != null && livingEntity.m_6084_();
        }

        public void m_8056_() {
            this.banshee.attackTime = 20;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.banshee.attackTime;
            LivingEntity target = this.banshee.m_5448_();
            if (target != null) {
                this.banshee.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
                double distance = this.banshee.m_20280_((Entity)target);
                if (distance < 5.0 && this.banshee.f_19796_.m_188503_(30) == 0) {
                    this.banshee.teleport();
                } else if (distance < 300.0) {
                    if (this.banshee.attackTime == 20) {
                        this.banshee.m_9236_().m_7967_((Entity)new WillOWisp((LivingEntity)this.banshee, this.banshee.m_9236_(), target, this.banshee.m_20185_(), this.banshee.m_20186_() + 0.5, this.banshee.m_20189_(), 0.2f, 6));
                        this.banshee.m_5496_((SoundEvent)JNESoundEvents.ENTITY_BANSHEE_SHOOT.get(), 2.0f, (this.banshee.f_19796_.m_188501_() - this.banshee.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    }
                    if (this.banshee.attackTime <= 0) {
                        this.banshee.attackTime = 40 + this.banshee.f_19796_.m_188503_(30);
                        this.banshee.teleport();
                    }
                }
                super.m_8037_();
            }
        }
    }
}

