/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.jadenxgamer.netherexp.registry.entity.custom.Vessel;
import net.jadenxgamer.netherexp.registry.misc_registry.JNEAnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class VesselModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("modid", "vesselmodel"), "main");
    private final ModelPart vessel;
    private final ModelPart head;

    public VesselModel(ModelPart root) {
        this.vessel = root.m_171324_("vessel");
        this.head = this.vessel.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition vessel = partdefinition.m_171599_("vessel", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = vessel.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(0.0f, -9.0f, -5.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-35.0f, (float)0.0f));
        PartDefinition body = vessel.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-35.25f, (float)0.0f));
        PartDefinition waist = body.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171488_(-3.0f, -13.0f, -2.0f, 6.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-4.0f, -13.0f, -3.0f, 8.0f, 14.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)19.25f, (float)0.0f));
        PartDefinition collar = waist.m_171599_("collar", CubeListBuilder.m_171558_().m_171514_(22, 8).m_171488_(-8.0f, -3.0f, -5.0f, 16.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition eyes = collar.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-6.0f, -2.0f, 0.0f, 12.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.1f));
        PartDefinition left_arm = waist.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(44, 35).m_171488_(-1.0f, 6.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(36, 27).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_arm = waist.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(28, 35).m_171488_(-3.0f, 6.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 27).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-13.0f, (float)0.0f));
        PartDefinition left_leg = vessel.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(8, 60).m_171488_(-1.0f, -0.5f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-14.5f, (float)0.0f));
        PartDefinition right_leg = vessel.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171488_(-1.0f, -0.5f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-14.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.m_267799_(JNEAnimationDefinition.VESSEL_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.m_233381_(((Vessel)((Object)entity)).idleAnimationState, JNEAnimationDefinition.VESSEL_IDLE, ageInTicks);
        this.m_233381_(((Vessel)((Object)entity)).blinkAnimationState, JNEAnimationDefinition.VESSEL_BLINK, ageInTicks);
        this.m_233381_(((Vessel)((Object)entity)).aimAnimationState, JNEAnimationDefinition.VESSEL_AIM, ageInTicks);
        this.m_233381_(((Vessel)((Object)entity)).aimIdleAnimationState, JNEAnimationDefinition.VESSEL_AIM_IDLE, ageInTicks);
        this.m_233381_(((Vessel)((Object)entity)).shootAnimationState, JNEAnimationDefinition.VESSEL_AIM_SHOOT, ageInTicks);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.vessel.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.vessel;
    }
}

