/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.entity;

import java.util.Objects;
import javax.annotation.Nullable;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlockEntityType;
import net.jadenxgamer.netherexp.registry.block.custom.BrazierChestBlock;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BrazierChestBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter;
    private int lockTimer = JNEConfigs.BRAZIER_CHEST_REFILL_COOLDOWN.get() * 20;
    @Nullable
    protected ResourceLocation refillLootTable;

    public BrazierChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)JNEBlockEntityType.BRAZIER_CHEST.get(), pos, state);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(Level arg, BlockPos arg2, BlockState arg3) {
                BrazierChestBlockEntity.this.playSound(arg3, (SoundEvent)JNESoundEvents.BRAZIER_CHEST_OPEN.get());
                BrazierChestBlockEntity.this.updateBlockState(arg3, true);
            }

            protected void m_142289_(Level level, BlockPos pos, BlockState state) {
                BrazierChestBlockEntity.this.playSound(state, (SoundEvent)JNESoundEvents.BRAZIER_CHEST_CLOSE.get());
                BrazierChestBlockEntity.this.updateBlockState(state, false);
            }

            protected void m_142148_(Level level, BlockPos pos, BlockState state, int i, int j) {
            }

            protected boolean m_142718_(Player player) {
                if (player.f_36096_ instanceof ChestMenu) {
                    Container container = ((ChestMenu)player.f_36096_).m_39261_();
                    return container == BrazierChestBlockEntity.this;
                }
                return false;
            }
        };
    }

    public void refillLoot() {
        if (this.f_58857_ != null) {
            if (this.refillLootTable == null) {
                this.refillLootTable = Objects.requireNonNullElseGet(this.f_59605_, () -> new ResourceLocation("netherexp:brazier_chest/exposed"));
            }
            this.m_6211_();
            BrazierChestBlockEntity.m_222766_((BlockGetter)this.f_58857_, (RandomSource)this.f_58857_.f_46441_, (BlockPos)this.m_58899_(), (ResourceLocation)this.refillLootTable);
        }
    }

    public int m_6643_() {
        return 27;
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> stack) {
        this.items = stack;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.brazier_chest");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return ChestMenu.m_39237_((int)i, (Inventory)inventory, (Container)this);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("LockTimer", this.lockTimer);
        if (this.refillLootTable != null) {
            nbt.m_128359_("RefillLootTable", this.refillLootTable.toString());
        }
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.lockTimer = nbt.m_128451_("LockTimer");
        if (nbt.m_128425_("RefillLootTable", 8)) {
            this.refillLootTable = new ResourceLocation(nbt.m_128461_("RefillLootTable"));
        }
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean locked = (Boolean)state.m_61143_((Property)BrazierChestBlock.LOCKED);
        if (level != null && !locked) {
            --this.lockTimer;
            if (this.lockTimer <= 0) {
                this.m_6211_();
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BrazierChestBlock.LOCKED, (Comparable)Boolean.valueOf(true)), 2);
                level.m_5594_(null, this.m_58899_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.lockTimer = JNEConfigs.BRAZIER_CHEST_REFILL_COOLDOWN.get() * 20;
            }
        }
    }

    void updateBlockState(BlockState state, boolean bl) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)BrazierChestBlock.OPEN, (Comparable)Boolean.valueOf(bl)), 3);
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)BrazierChestBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        assert (this.f_58857_ != null);
        this.f_58857_.m_6263_(null, d, e, f, sound, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

