/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallGrowingWartBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0)));
    private final Supplier<Item> cloneItemSupplier;

    public WallGrowingWartBlock(BlockBehaviour.Properties properties, Supplier<Item> cloneItemSupplier) {
        super(properties);
        this.cloneItemSupplier = cloneItemSupplier;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return WallGrowingWartBlock.getShape(state);
    }

    public static VoxelShape getShape(BlockState state) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos supportPos = pos.m_121945_(direction.m_122424_());
        BlockState supportState = level.m_8055_(supportPos);
        return supportState.m_60713_(Blocks.f_50135_);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3 && random.m_188503_(10) == 0) {
            state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.m_7731_(pos, state, 2);
        }
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.cloneItemSupplier.get());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        BlockState state = this.m_49966_();
        Level levelReader = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction direction : directions = context.m_6232_()) {
            Direction direction2;
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)levelReader, pos)) continue;
            return state;
        }
        return null;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AGE});
    }
}

