/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import com.google.common.collect.Maps;
import java.util.Map;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class EctoplasmLiquidBlock
extends LiquidBlock {
    private static Map<Block, Block> FREEZES;

    public EctoplasmLiquidBlock(RegistryObject<FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean bl) {
        super.m_6807_(state, level, pos, oldState, bl);
        if (JNEConfigs.ECTOPLASM_RUSTS_NETHERITE.get().booleanValue()) {
            this.checkFreeze(level, pos);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos abovePos = pos.m_7494_();
        if (state.m_60819_().m_76170_() && !level.m_8055_(abovePos).m_60804_((BlockGetter)level, abovePos) && JNEConfigs.ENABLE_ECTOPLASM_PARTICLES.get().booleanValue()) {
            double f;
            double e;
            double d;
            if (random.m_188503_(55) == 0) {
                d = (double)pos.m_123341_() + random.m_188500_();
                e = (double)pos.m_123342_() + 1.0;
                f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)JNEParticleTypes.ECTORAYS.get(), d, e, f, 0.0, -0.03, 0.0);
            }
            if (random.m_188503_(18) == 0) {
                d = (double)pos.m_123341_() + random.m_188500_();
                e = (double)pos.m_123342_() + 1.0;
                f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)JNEParticleTypes.ECTOPLASMA.get(), d, e, f, 0.0, 0.0, 0.0);
            }
            if (random.m_188503_(600) == 0 && JNEConfigs.ENABLE_ECTOPLASM_SOUNDS.get().booleanValue()) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)JNESoundEvents.ECTOPLASM_WHISPERING.get(), SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean bl) {
        super.m_6861_(state, level, pos, block, fromPos, bl);
        if (JNEConfigs.ECTOPLASM_RUSTS_NETHERITE.get().booleanValue()) {
            this.checkFreeze(level, pos);
        }
    }

    public void checkFreeze(Level level, BlockPos pos) {
        Direction[] faces;
        EctoplasmLiquidBlock.initFreeze();
        for (Direction direction : faces = Direction.values()) {
            BlockPos offset = pos.m_121955_(direction.m_122436_());
            BlockState oldState = level.m_8055_(offset);
            if (!FREEZES.containsKey(oldState.m_60734_())) continue;
            BlockState newState = FREEZES.get(oldState.m_60734_()).m_49966_();
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)JNESoundEvents.SOUL_SLATE_SOLIDIFYING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            for (Property property : oldState.m_61147_()) {
                newState = newState.m_61138_(property) ? (BlockState)newState.m_61124_(property, oldState.m_61143_(property)) : newState;
            }
            level.m_7731_(offset, newState, 2);
        }
    }

    private static void initFreeze() {
        if (FREEZES != null) {
            return;
        }
        FREEZES = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put((Block)JNEBlocks.NETHERITE_PLATED_BLOCK.get(), (Block)JNEBlocks.RUSTY_NETHERITE_PLATED_BLOCK.get());
            map.put((Block)JNEBlocks.NETHERITE_GRATE.get(), (Block)JNEBlocks.RUSTY_NETHERITE_GRATE.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_BLOCK.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_BLOCK.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_SLAB.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_SLAB.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_STAIRS.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_STAIRS.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_PILLAR.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_PILLAR.get());
        });
    }
}

