/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.block.custom.JNEBrushableBlock;
import net.jadenxgamer.netherexp.registry.block.entity.JNEBrushableBlockEntity;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Wisp;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EctoSoulSandBlock
extends Block {
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final BooleanProperty SALTED = BooleanProperty.m_61465_((String)"salted");
    public static final ResourceLocation ARCHAEOLOGY_NETHER_WASTES = new ResourceLocation("netherexp", "archaeology/nether_wastes");
    public static final ResourceLocation ARCHAEOLOGY_SOUL_SAND_VALLEY = new ResourceLocation("netherexp", "archaeology/soul_sand_valley");
    public static final ResourceLocation ARCHAEOLOGY_CRIMSON_FOREST = new ResourceLocation("netherexp", "archaeology/crimson_forest");
    public static final ResourceLocation ARCHAEOLOGY_WARPED_FOREST = new ResourceLocation("netherexp", "archaeology/warped_forest");
    public static final ResourceLocation ARCHAEOLOGY_BASALT_DELTAS = new ResourceLocation("netherexp", "archaeology/basalt_deltas");
    public static final ResourceLocation ARCHAEOLOGY_FORTRESS = new ResourceLocation("netherexp", "archaeology/fortress");
    public static final ResourceLocation ARCHAEOLOGY_BASTION_REMNANT = new ResourceLocation("netherexp", "archaeology/bastion_remnant");

    public EctoSoulSandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SALTED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)SALTED) == false;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        boolean salted = (Boolean)state.m_61143_((Property)SALTED);
        if (!salted) {
            if (itemStack.m_150930_(Items.f_271356_) && level.m_8055_(pos.m_7494_()).m_60795_()) {
                level.m_5594_(player, pos, SoundEvents.f_271174_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                level.m_5594_(player, pos, (SoundEvent)JNESoundEvents.ENTITY_WISP_AMBIENT.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                if (!player.m_7500_()) {
                    itemStack.m_41622_(4, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                if (level.f_46441_.m_188503_(15) == 0 && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.setSusSoulSand(level, pos, level.f_46441_);
                    this.spawnWisp(serverLevel, pos.m_7494_(), level.f_46441_);
                }
                EctoSoulSandBlock.blockParticle(level, pos, (ParticleOptions)ParticleTypes.f_123746_);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (itemStack.m_150930_(Items.f_42784_)) {
                level.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)SALTED), 2);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                EctoSoulSandBlock.blockParticle(level, pos, (ParticleOptions)ParticleTypes.f_175828_);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static void blockParticle(Level level, BlockPos pos, ParticleOptions particle) {
        Direction[] var5;
        RandomSource randomSource = level.f_46441_;
        for (Direction direction : var5 = Direction.values()) {
            BlockPos blockPos2 = pos.m_121945_(direction);
            if (level.m_8055_(blockPos2).m_60804_((BlockGetter)level, blockPos2)) continue;
            Direction.Axis axis = direction.m_122434_();
            double e = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)randomSource.m_188501_();
            double f = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)randomSource.m_188501_();
            double g = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)randomSource.m_188501_();
            level.m_7106_(particle, (double)pos.m_123341_() + e, (double)pos.m_123342_() + f, (double)pos.m_123343_() + g, 0.0, 0.0, 0.0);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int emergingOdds = random.m_188503_(JNEConfigs.WISP_EMERGING_CHANCE.get().intValue());
        if (emergingOdds == 0 && !level.m_8055_(pos.m_7495_()).m_60795_()) {
            BlockPos targetPos = this.findAirNeighbor(level, pos);
            if (JNEConfigs.SUSPICIOUS_SOUL_SAND_FROM_WISP_EMERGING.get().booleanValue()) {
                this.setSusSoulSand((Level)level, pos, random);
            }
            if (targetPos != null) {
                this.spawnWisp(level, targetPos, random);
            }
        }
    }

    private BlockPos findAirNeighbor(ServerLevel level, BlockPos pos) {
        Direction[] directions;
        for (Direction direction : directions = Direction.values()) {
            BlockPos neighborPos = pos.m_121955_(direction.m_122436_());
            if (!level.m_8055_(neighborPos).m_60795_()) continue;
            return neighborPos;
        }
        return null;
    }

    private void setSusSoulSand(Level level, BlockPos pos, RandomSource random) {
        ResourceLocation lootTable = ARCHAEOLOGY_NETHER_WASTES;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            StructureManager structureManager = serverLevel.m_215010_();
            if (structureManager.m_220494_(pos, (Structure)serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_6246_(BuiltinStructures.f_209859_)).m_73603_()) {
                lootTable = ARCHAEOLOGY_FORTRESS;
            } else if (structureManager.m_220494_(pos, (Structure)serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_6246_(BuiltinStructures.f_209863_)).m_73603_()) {
                lootTable = ARCHAEOLOGY_BASTION_REMNANT;
            } else if (serverLevel.m_204166_(pos).m_203565_(Biomes.f_48199_)) {
                lootTable = ARCHAEOLOGY_SOUL_SAND_VALLEY;
            } else if (serverLevel.m_204166_(pos).m_203565_(Biomes.f_48200_)) {
                lootTable = ARCHAEOLOGY_CRIMSON_FOREST;
            } else if (serverLevel.m_204166_(pos).m_203565_(Biomes.f_48201_)) {
                lootTable = ARCHAEOLOGY_WARPED_FOREST;
            } else if (serverLevel.m_204166_(pos).m_203565_(Biomes.f_48175_)) {
                lootTable = ARCHAEOLOGY_BASALT_DELTAS;
            }
        }
        level.m_7731_(pos, (BlockState)((Block)JNEBlocks.SUSPICIOUS_SOUL_SAND.get()).m_49966_().m_61124_((Property)JNEBrushableBlock.PERSISTENT, (Comparable)Boolean.valueOf(false)), 2);
        JNEBrushableBlockEntity.setLootTable((BlockGetter)level, random, pos, lootTable);
    }

    private void spawnWisp(ServerLevel level, BlockPos pos, RandomSource random) {
        Wisp wisp = (Wisp)((EntityType)JNEEntityType.WISP.get()).m_20615_((Level)level);
        if (wisp != null) {
            wisp.setBoredDelay(random.m_188503_(1000) + 600);
            wisp.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)wisp);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SALTED});
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @NotNull
    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83144_();
    }

    @NotNull
    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }
}

