/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BlackIcicleBlock
extends PointedDripstoneBlock {
    public BlackIcicleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos pos = pHit.m_82425_();
        if (!pLevel.f_46443_ && pProjectile.m_142265_(pLevel, pos) && pProjectile.m_20184_().m_82553_() > 0.6) {
            pLevel.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)f_154011_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pDirection != Direction.UP && pDirection != Direction.DOWN) {
            return pState;
        }
        Direction tipDir = (Direction)pState.m_61143_((Property)f_154009_);
        if (tipDir == Direction.DOWN && pLevel.m_183326_().m_183582_(pCurrentPos, (Object)this)) {
            return pState;
        }
        if (pDirection == tipDir.m_122424_() && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos)) {
            if (tipDir == Direction.DOWN) {
                pLevel.m_186460_(pCurrentPos, (Block)this, 2);
            } else {
                pLevel.m_186460_(pCurrentPos, (Block)this, 1);
            }
            return pState;
        }
        boolean merged = pState.m_61143_((Property)f_154010_) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness thickness = BlackIcicleBlock.calculateIcicleThickness((LevelReader)pLevel, pCurrentPos, tipDir, merged);
        return (BlockState)pState.m_61124_((Property)f_154010_, (Comparable)thickness);
    }

    public void m_142525_(Level pLevel, BlockPos pPos, FallingBlockEntity pFallingBlock) {
        if (!pFallingBlock.m_20067_()) {
            pLevel.m_46796_(2001, pPos, BlackIcicleBlock.m_49956_((BlockState)this.m_49966_()));
            pLevel.m_5594_(null, pPos, (SoundEvent)JNESoundEvents.BLOCK_BLACK_ICE_BREAK.get(), SoundSource.BLOCKS, 0.7f, 1.5f);
        }
        List entities = pLevel.m_45976_(Entity.class, new AABB(pPos).m_82400_(1.0));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (pFallingBlock.m_31980_().m_61143_((Property)f_154010_) != DripstoneThickness.TIP) continue;
            livingEntity.m_146917_(livingEntity.m_146888_() + JNEConfigs.BLACK_ICICLE_FREEZE_TICKS.get());
        }
    }

    public DamageSource m_252932_(Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            pEntity.m_146917_(pEntity.m_146888_() + 5);
        }
        return super.m_252932_(pEntity);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BlackIcicleBlock.isValidIciclePlacement(pLevel, pPos, (Direction)pState.m_61143_((Property)f_154009_));
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (BlackIcicleBlock.m_154242_(pState) && !this.m_7898_(pState, (LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        } else {
            BlackIcicleBlock.spawnFallingIcicle(pState, pLevel, pPos);
        }
    }

    private static boolean isValidIciclePlacement(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return BlackIcicleBlock.m_49863_((LevelReader)level, (BlockPos)blockPos, (Direction)direction) || BlackIcicleBlock.isIcicleWithDirection(blockState, direction);
    }

    private static void spawnFallingIcicle(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos mutablePos = pPos.m_122032_();
        BlockState icicle = pState;
        while (BlackIcicleBlock.m_154240_(icicle)) {
            FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)mutablePos, (BlockState)icicle);
            if (BlackIcicleBlock.m_154153_(icicle, true)) {
                int max = Math.max(1 + pPos.m_123342_() - mutablePos.m_123342_(), 6);
                float f = max;
                fallingBlock.m_149656_(f, 15);
                break;
            }
            mutablePos.m_122173_(Direction.DOWN);
            icicle = pLevel.m_8055_((BlockPos)mutablePos);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188501_() < 0.011377778f) {
            if (BlackIcicleBlock.m_154203_(pState, (LevelReader)pLevel, pPos)) {
                BlackIcicleBlock.growIcicleIfPossible(pState, pLevel, pPos, Direction.DOWN);
            } else if (BlackIcicleBlock.isStalagmiteStartPos(pState, (LevelAccessor)pLevel, pPos)) {
                BlackIcicleBlock.growIcicleIfPossible(pState, pLevel, pPos, Direction.UP);
            }
        }
    }

    public static void growIcicleIfPossible(BlockState pState, ServerLevel pLevel, BlockPos pPos, Direction growthDirection) {
        BlockState tipState;
        BlockPos tip = BlackIcicleBlock.m_154130_(pState, (LevelAccessor)pLevel, pPos, 7, false);
        if (tip != null && BlackIcicleBlock.m_154194_(tipState = pLevel.m_8055_(tip), pLevel, tip) && ((Boolean)tipState.m_61143_((Property)f_154011_)).booleanValue()) {
            BlackIcicleBlock.m_154035_(pLevel, tip, growthDirection);
        }
    }

    private static void m_154035_(ServerLevel pServer, BlockPos pPos, Direction pDirection) {
        BlockPos relative = pPos.m_121945_(pDirection);
        BlockState relativeState = pServer.m_8055_(relative);
        if (BlackIcicleBlock.m_154143_(relativeState, pDirection.m_122424_())) {
            BlackIcicleBlock.m_154230_(relativeState, (LevelAccessor)pServer, relative);
        } else if (relativeState.m_60795_() || relativeState.m_60713_(Blocks.f_49990_)) {
            BlackIcicleBlock.crateIcicle((LevelAccessor)pServer, relative, pDirection, DripstoneThickness.TIP);
        }
    }

    private static void crateIcicle(LevelAccessor pLevel, BlockPos pPos, Direction pDirection, DripstoneThickness pThickness) {
        BlockState state = (BlockState)((BlockState)((BlockState)((Block)JNEBlocks.BLACK_ICICLE.get()).m_49966_().m_61124_((Property)f_154009_, (Comparable)pDirection)).m_61124_((Property)f_154010_, (Comparable)pThickness)).m_61124_((Property)f_154011_, (Comparable)Boolean.valueOf(pLevel.m_6425_(pPos).m_76152_() == Fluids.f_76193_));
        pLevel.m_7731_(pPos, state, 3);
    }

    private static void m_154230_(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        BlockPos above;
        BlockPos below;
        if (pState.m_61143_((Property)f_154009_) == Direction.UP) {
            below = pPos;
            above = pPos.m_7494_();
        } else {
            above = pPos;
            below = pPos.m_7495_();
        }
        BlackIcicleBlock.crateIcicle(pLevel, above, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        BlackIcicleBlock.crateIcicle(pLevel, below, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    @Nullable
    private static BlockPos m_154130_(BlockState pState, LevelAccessor pLevel, BlockPos pPos, int pMaxIterations, boolean pIsTipMerge) {
        if (BlackIcicleBlock.m_154153_(pState, pIsTipMerge)) {
            return pPos;
        }
        Direction direction = (Direction)pState.m_61143_((Property)f_154009_);
        BiPredicate<BlockPos, BlockState> biPredicate = (pos, state) -> state.m_60713_(Blocks.f_152588_) && state.m_61143_((Property)f_154009_) == direction;
        return BlackIcicleBlock.m_202006_(pLevel, pPos, direction.m_122421_(), biPredicate, p -> BlackIcicleBlock.m_154153_(p, pIsTipMerge), pMaxIterations).orElse(null);
    }

    private static boolean m_154194_(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)f_154009_);
        BlockPos relative = pPos.m_121945_(direction);
        BlockState relativeState = pLevel.m_8055_(relative);
        if (!relativeState.m_60819_().m_76178_()) {
            return false;
        }
        return relativeState.m_60795_() || relativeState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || BlackIcicleBlock.m_154143_(relativeState, direction.m_122424_());
    }

    private static Optional<BlockPos> m_202006_(LevelAccessor pLevel, BlockPos pPos, Direction.AxisDirection pAxis, BiPredicate<BlockPos, BlockState> pPositionalStatePredicate, Predicate<BlockState> pStatePredicate, int pMaxIterations) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)pAxis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutablePos = pPos.m_122032_();
        for (int i = 1; i < pMaxIterations; ++i) {
            mutablePos.m_122173_(direction);
            BlockState mutableState = pLevel.m_8055_((BlockPos)mutablePos);
            if (pStatePredicate.test(mutableState)) {
                return Optional.of(mutablePos.m_7949_());
            }
            if (!pLevel.m_151562_(mutablePos.m_123342_()) && pPositionalStatePredicate.test((BlockPos)mutablePos, mutableState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction opposite;
        BlockPos pos;
        Level level = pContext.m_43725_();
        Direction direction = BlackIcicleBlock.m_154190_((LevelReader)level, pos = pContext.m_8083_(), opposite = pContext.m_151260_().m_122424_());
        if (direction == null) {
            return null;
        }
        boolean merge = !pContext.m_7078_();
        DripstoneThickness thickness = BlackIcicleBlock.calculateIcicleThickness((LevelReader)level, pos, direction, merge);
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_154009_, (Comparable)direction)).m_61124_((Property)f_154010_, (Comparable)thickness)).m_61124_((Property)f_154011_, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    private static Direction m_154190_(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        Direction direction;
        if (BlackIcicleBlock.isValidIciclePlacement(pLevel, pPos, pDir)) {
            direction = pDir;
        } else {
            if (!BlackIcicleBlock.isValidIciclePlacement(pLevel, pPos, pDir.m_122424_())) {
                return null;
            }
            direction = pDir.m_122424_();
        }
        return direction;
    }

    private static boolean m_154153_(BlockState pState, boolean pIsTipMerge) {
        if (!pState.m_60713_((Block)JNEBlocks.BLACK_ICICLE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)pState.m_61143_((Property)f_154010_);
        return thickness == DripstoneThickness.TIP || pIsTipMerge && thickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean m_154143_(BlockState pState, Direction pDir) {
        return BlackIcicleBlock.m_154153_(pState, false) && pState.m_61143_((Property)f_154009_) == pDir;
    }

    private static boolean m_154203_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BlackIcicleBlock.m_154240_(pState) && !pLevel.m_8055_(pPos.m_7494_()).m_60713_((Block)JNEBlocks.BLACK_ICICLE.get());
    }

    private static boolean isStalagmiteStartPos(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        BlockState belowState = pLevel.m_8055_(pPos.m_7495_());
        return belowState.m_60804_((BlockGetter)pLevel, pPos.m_7495_()) && !pState.m_60819_().m_76178_();
    }

    private static boolean m_154240_(BlockState pState) {
        return BlackIcicleBlock.isIcicleWithDirection(pState, Direction.DOWN);
    }

    private static boolean m_154242_(BlockState pState) {
        return BlackIcicleBlock.isIcicleWithDirection(pState, Direction.UP);
    }

    private static boolean isIcicleWithDirection(BlockState pState, Direction pDir) {
        return pState.m_60713_((Block)JNEBlocks.BLACK_ICICLE.get()) && pState.m_61143_((Property)f_154009_) == pDir;
    }

    private static DripstoneThickness calculateIcicleThickness(LevelReader pLevel, BlockPos pPos, Direction pDir, boolean pIsTipMerge) {
        Direction opposite = pDir.m_122424_();
        BlockState rPos = pLevel.m_8055_(pPos.m_121945_(pDir));
        if (BlackIcicleBlock.isIcicleWithDirection(rPos, opposite)) {
            return !pIsTipMerge && rPos.m_61143_((Property)f_154010_) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!BlackIcicleBlock.isIcicleWithDirection(rPos, pDir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness thickness = (DripstoneThickness)rPos.m_61143_((Property)f_154010_);
        if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
            BlockState roPos = pLevel.m_8055_(pPos.m_121945_(opposite));
            return !BlackIcicleBlock.isIcicleWithDirection(roPos, pDir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }
}

