/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.mixin.block;

import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.TwistingVinesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TwistingVinesBlock.class})
public abstract class TwistingVinesMixin
extends GrowingPlantHeadBlock {
    @Unique
    private static final BooleanProperty BUDDING = BooleanProperty.m_61465_((String)"budding");

    public TwistingVinesMixin(BlockBehaviour.Properties properties, Direction growthDirection, VoxelShape outlineShape, boolean tickWater, double growthChance) {
        super(properties, growthDirection, outlineShape, tickWater, growthChance);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float chance = random.m_188503_(50);
        boolean budding = (Boolean)state.m_61143_((Property)BUDDING);
        if (chance == 0.0f && budding && JNEConfigs.SHOULD_NETHER_VINES_GROW_SPORES.get().booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)BUDDING), 2);
        }
        super.m_213898_(state, level, pos, random);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        boolean budding = (Boolean)state.m_61143_((Property)BUDDING);
        float f = random.m_188501_();
        double x = (double)pos.m_123341_() + random.m_188500_();
        double y = (double)pos.m_123342_() + 0.8;
        double z = (double)pos.m_123343_() + random.m_188500_();
        if (!budding && (double)f < 0.3) {
            level.m_7106_((ParticleOptions)JNEParticleTypes.RISING_SHROOMNIGHT.get(), x, y, z, Mth.m_216263_((RandomSource)random, (double)-0.02, (double)0.02), 0.08, Mth.m_216263_((RandomSource)random, (double)-0.02, (double)0.02));
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        boolean budding = (Boolean)state.m_61143_((Property)BUDDING);
        boolean bl = false;
        if (budding) {
            if (itemStack.m_150930_((Item)JNEItems.NIGHTSPORES.get())) {
                level.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)JNESoundEvents.LIGHTSPORES_APPLY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)BUDDING), 2);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                TwistingVinesMixin.netherexp$sporeParticles(level, pos);
                bl = true;
            }
        } else if (itemStack.m_150930_(Items.f_42574_)) {
            TwistingVinesMixin.netherexp$dropNight(level, pos);
            level.m_5594_(player, pos, (SoundEvent)JNESoundEvents.LIGHTSPORES_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)BUDDING), 2);
            level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            bl = true;
        }
        if (!level.f_46443_ && bl) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        }
        if (bl) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Unique
    private static void netherexp$dropNight(Level level, BlockPos pos) {
        TwistingVinesMixin.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)JNEItems.NIGHTSPORES.get(), 1));
    }

    @Unique
    private static void netherexp$sporeParticles(Level level, BlockPos pos) {
        RandomSource random = level.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockPos = pos.m_121955_(direction.m_122436_());
            if (level.m_8055_(blockPos).m_60804_((BlockGetter)level, blockPos)) continue;
            Direction.Axis axis = direction.m_122434_();
            double e = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.m_188501_();
            double f = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.m_188501_();
            double g = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.m_188501_();
            level.m_7106_((ParticleOptions)JNEParticleTypes.FALLING_SHROOMNIGHT.get(), (double)pos.m_123341_() + e, (double)pos.m_123342_() + f, (double)pos.m_123343_() + g, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BUDDING, f_53924_});
    }
}

