/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp;

import com.mojang.logging.LogUtils;
import net.jadenxgamer.elysium_api.api.biome.ElysiumBiomeRegistry;
import net.jadenxgamer.elysium_api.api.surface_rules.SurfaceRulesRegistry;
import net.jadenxgamer.netherexp.NetherExpClient;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.config.JNEForgeConfigs;
import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.jadenxgamer.netherexp.registry.block.JNEBlockEntityType;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.effect.JNEMobEffects;
import net.jadenxgamer.netherexp.registry.enchantment.JNEEnchantments;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Apparition;
import net.jadenxgamer.netherexp.registry.entity.custom.Banshee;
import net.jadenxgamer.netherexp.registry.entity.custom.Carcass;
import net.jadenxgamer.netherexp.registry.entity.custom.EctoSlab;
import net.jadenxgamer.netherexp.registry.entity.custom.Stampede;
import net.jadenxgamer.netherexp.registry.entity.custom.Vessel;
import net.jadenxgamer.netherexp.registry.entity.custom.Wisp;
import net.jadenxgamer.netherexp.registry.fluid.JNEFluids;
import net.jadenxgamer.netherexp.registry.item.JNECreativeModeTabs;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.item.brewing.JNEPotionRecipe;
import net.jadenxgamer.netherexp.registry.loot.JNELootModifiers;
import net.jadenxgamer.netherexp.registry.misc_registry.JNEBuiltinPacks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNEPaintings;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.jadenxgamer.netherexp.registry.worldgen.JNEBiomeModifiers;
import net.jadenxgamer.netherexp.registry.worldgen.JNEBiomes;
import net.jadenxgamer.netherexp.registry.worldgen.JNESurfaceRules;
import net.jadenxgamer.netherexp.registry.worldgen.feature.JNEFeature;
import net.jadenxgamer.netherexp.registry.worldgen.structure.JNEStructureType;
import net.jadenxgamer.netherexp.util.CompatUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="netherexp")
public class NetherExp {
    public static final String MOD_ID = "netherexp";
    public static final Logger LOGGER = LogUtils.getLogger();

    public NetherExp() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> NetherExpClient::init);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)JNEForgeConfigs.COMMON);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(NetherExp::registerAttributes);
        modEventBus.addListener(NetherExp::registerSpawnPlacements);
        modEventBus.addListener(NetherExp::loadComplete);
        modEventBus.addListener(NetherExp::addBuiltinPacks);
        MinecraftForge.EVENT_BUS.register((Object)this);
        JNECriteriaTriggers.init();
        JNECreativeModeTabs.init(modEventBus);
        JNESoundEvents.init(modEventBus);
        JNEParticleTypes.init(modEventBus);
        JNEEnchantments.init(modEventBus);
        JNEMobEffects.init(modEventBus);
        JNEEntityType.init(modEventBus);
        JNEStructureType.init(modEventBus);
        JNEFluids.init(modEventBus);
        JNEPaintings.init(modEventBus);
        JNEBlocks.init(modEventBus);
        JNEFeature.init(modEventBus);
        JNEBlockEntityType.init(modEventBus);
        JNEItems.init(modEventBus);
        JNEBiomeModifiers.init(modEventBus);
        JNELootModifiers.init(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SurfaceRulesRegistry.registerSurfaceRule((SurfaceRules.RuleSource)JNESurfaceRules.init());
            JNEPotionRecipe.addInvokerPotionRecipes();
        });
    }

    @SubscribeEvent
    public void onServerStart(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen registryAccess = event.getServer().m_206579_();
        if (JNEConfigs.ENABLE_SUB_BIOMES.get().booleanValue()) {
            ElysiumBiomeRegistry.replaceNetherBiome((ResourceKey)Biomes.f_48199_, JNEBiomes.BLACK_ICE_GLACIERS, (double)JNEConfigs.BLACK_ICE_GLACIERS_RARITY.get(), (int)JNEConfigs.BLACK_ICE_GLACIERS_SIZE.get(), (ResourceLocation)new ResourceLocation(MOD_ID, "ssv_3"), (RegistryAccess)registryAccess);
        }
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)JNEEntityType.APPARITION.get(), Apparition.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.WISP.get(), Wisp.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.VESSEL.get(), Vessel.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.ECTO_SLAB.get(), EctoSlab.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.BANSHEE.get(), Banshee.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.STAMPEDE.get(), Stampede.createAttributes().m_22265_());
        event.put((EntityType)JNEEntityType.CARCASS.get(), Carcass.createAttributes().m_22265_());
    }

    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)JNEEntityType.VESSEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)JNEEntityType.APPARITION.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)JNEEntityType.BANSHEE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(JNEFluids::initFluidInteractions);
    }

    private static void addBuiltinPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            JNEBuiltinPacks.rpJNERetextures(event);
            JNEBuiltinPacks.rpConflictingRetextures(event);
            JNEBuiltinPacks.rpUniqueNetherWood(event);
        }
        if (event.getPackType() == PackType.SERVER_DATA) {
            if (JNEConfigs.LARGER_NETHER_BIOMES.get().booleanValue()) {
                JNEBuiltinPacks.dpLargerNetherBiomes(event);
            }
            if (CompatUtil.checkNethersDelight()) {
                JNEBuiltinPacks.dpNethersDelightCompat(event);
            }
            if (CompatUtil.checkAlexsCaves()) {
                JNEBuiltinPacks.dpAlexCavesCompat(event);
            }
            if (CompatUtil.checkGardensOfTheDead()) {
                JNEBuiltinPacks.dpGardensOfTheDeadCompat(event);
            }
            if (CompatUtil.checkRubinatedNether()) {
                JNEBuiltinPacks.dpRubinatedNetherCompat(event);
            }
            if (CompatUtil.checkCavernsAndChasms()) {
                JNEBuiltinPacks.dpCavernsAndChasmsCompat(event);
            }
            if (CompatUtil.checkOreganized()) {
                JNEBuiltinPacks.dpOreganizedCompat(event);
            }
        }
    }
}

