/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import info.u_team.u_team_core.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class VoxelShapeUtil {
    public static List<VoxelShape> createVoxelShapeFromVector(List<Pair<Vec3, Vec3>> list) {
        return list.stream().map(pair -> {
            Vec3 vec1 = (Vec3)pair.getLeft();
            Vec3 vec2 = (Vec3)pair.getRight();
            AABB aabb = new AABB(vec1, vec2);
            return Block.m_49796_((double)aabb.f_82288_, (double)aabb.f_82289_, (double)aabb.f_82290_, (double)aabb.f_82291_, (double)aabb.f_82292_, (double)aabb.f_82293_);
        }).collect(Collectors.toList());
    }

    public static Pair<Vec3, Vec3> createVectorPair(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Pair.of((Object)new Vec3(x1, y1, z1), (Object)new Vec3(x2, y2, z2));
    }

    public static List<Pair<Vec3, Vec3>> rotateAroundY(List<Pair<Vec3, Vec3>> list, double angle) {
        return list.stream().map(pair -> {
            Vec3 vec1 = MathUtil.rotateVectorAroundYCC((Vec3)((Vec3)pair.getLeft()).m_82492_(8.0, 8.0, 8.0), (double)angle).m_82520_(8.0, 8.0, 8.0);
            Vec3 vec2 = MathUtil.rotateVectorAroundYCC((Vec3)((Vec3)pair.getRight()).m_82492_(8.0, 8.0, 8.0), (double)angle).m_82520_(8.0, 8.0, 8.0);
            return Pair.of((Object)vec1, (Object)vec2);
        }).collect(Collectors.toList());
    }

    public static Map<Direction, List<Pair<Vec3, Vec3>>> getHorizontalRotations(List<Pair<Vec3, Vec3>> northShape) {
        HashMap<Direction, List<Pair<Vec3, Vec3>>> shapes = new HashMap<Direction, List<Pair<Vec3, Vec3>>>();
        shapes.put(Direction.NORTH, northShape);
        shapes.put(Direction.EAST, VoxelShapeUtil.rotateAroundY(northShape, -1.5707963267948966));
        shapes.put(Direction.SOUTH, VoxelShapeUtil.rotateAroundY(northShape, Math.PI));
        shapes.put(Direction.WEST, VoxelShapeUtil.rotateAroundY(northShape, 1.5707963267948966));
        return shapes;
    }
}

