/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import com.google.common.base.Predicates;
import info.u_team.useful_railroads.inventory.BlockTagItemStackHandler;
import info.u_team.useful_railroads.inventory.TrackBuilderInventoryWrapper;
import info.u_team.useful_railroads.util.ItemHandlerUtil;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;

public abstract class TrackBuilderManager {
    protected final Level level;
    protected final Direction direction;
    protected final BlockPos startPos;
    protected final TrackBuilderMode mode;
    protected final Set<BlockPos> allPositionSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> firstRailPos = new HashSet<BlockPos>();
    protected final Set<BlockPos> railSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> groundSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> redstoneTorchSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> cobbleSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> airSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> tunnelSet = new HashSet<BlockPos>();
    protected final Set<BlockPos> torchSet = new HashSet<BlockPos>();

    private TrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode) {
        this.level = level;
        this.direction = Direction.m_122366_((double)lookVector.f_82479_, (double)lookVector.f_82480_, (double)lookVector.f_82481_);
        if (rayTraceFace.m_122434_().m_122479_()) {
            rayTracePos = rayTracePos.m_121945_(this.direction.m_122424_());
        }
        if (!level.m_8055_(rayTracePos).m_60815_()) {
            rayTracePos = rayTracePos.m_7495_();
        }
        this.startPos = rayTracePos.m_7949_();
        this.mode = mode;
    }

    public void calculateBlockPosition() {
        Direction directionLeft = this.direction.m_122428_();
        Direction directionRight = this.direction.m_122427_();
        this.calculate(directionLeft, directionRight);
        Stream.of(this.railSet, this.groundSet, this.tunnelSet, this.redstoneTorchSet, this.torchSet, this.cobbleSet, this.airSet).flatMap(Collection::stream).forEach(this.allPositionSet::add);
    }

    protected abstract void calculate(Direction var1, Direction var2);

    public void execute(Player player, TrackBuilderInventoryWrapper wrapper) {
        if (this.level.f_46443_ || !(this.level instanceof ServerLevel)) {
            return;
        }
        int cost = this.calculateCost();
        if (wrapper.getFuel() < cost) {
            player.m_213846_((Component)Component.m_237110_((String)"item.usefulrailroads.track_builder.not_enough_fuel", (Object[])new Object[]{cost}).m_130940_(ChatFormatting.RED));
            return;
        }
        if (!(this.hasEnoughItems(wrapper.getRailInventory(), this.railSet) && this.hasEnoughItems(wrapper.getGroundInventory(), this.groundSet) && this.hasEnoughItems(wrapper.getTunnelInventory(), this.tunnelSet) && this.hasEnoughItems(wrapper.getRedstoneTorchInventory(), this.redstoneTorchSet) && this.hasEnoughItems(wrapper.getTorchInventory(), this.torchSet))) {
            player.m_213846_((Component)Component.m_237115_((String)"item.usefulrailroads.track_builder.not_enough_blocks").m_130940_(ChatFormatting.RED));
            return;
        }
        wrapper.setFuel(wrapper.getFuel() - cost);
        List<ItemStack> railStacks = this.extractItems(wrapper.getRailInventory(), this.railSet);
        List<ItemStack> groundStacks = this.extractItems(wrapper.getGroundInventory(), this.groundSet);
        List<ItemStack> tunnelStacks = this.extractItems(wrapper.getTunnelInventory(), this.tunnelSet);
        List<ItemStack> redstoneTorchStacks = this.extractItems(wrapper.getRedstoneTorchInventory(), this.redstoneTorchSet);
        List<ItemStack> torchStacks = this.extractItems(wrapper.getTorchInventory(), this.torchSet);
        SimpleContainer dropInventory = new SimpleContainer(50);
        this.allPositionSet.stream().filter(Predicates.not(arg_0 -> ((Level)this.level).m_46859_(arg_0))).forEach(pos -> this.destroyBlock(player, (BlockPos)pos, dropInventory));
        Containers.m_18998_((Level)this.level, (Entity)player, (Container)dropInventory);
        this.cobbleSet.forEach(pos -> this.placeBlock((BlockPos)pos, Blocks.f_50652_.m_49966_()));
        this.redstoneTorchSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(redstoneTorchStacks)));
        this.groundSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(groundStacks)));
        this.railSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(railStacks)));
        this.tunnelSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(tunnelStacks)));
        this.torchSet.forEach(pos -> this.placeItemBlock((BlockPos)pos, ItemHandlerUtil.getOneItemAndRemove(torchStacks), (item, block) -> {
            boolean redstoneTorch;
            boolean bl = redstoneTorch = item == Items.f_41978_;
            if (redstoneTorch || item == Items.f_42000_) {
                Block torchWall = redstoneTorch ? Blocks.f_50123_ : Blocks.f_50082_;
                Block torchGround = redstoneTorch ? Blocks.f_50174_ : Blocks.f_50081_;
                return Stream.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).map(direction -> (BlockState)torchWall.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction)).filter(state -> state.m_60710_((LevelReader)this.level, pos)).findAny().orElseGet(() -> ((Block)torchGround).m_49966_());
            }
            return block.m_49966_();
        }));
        wrapper.writeItemStack();
    }

    private void placeItemBlock(BlockPos pos, ItemStack stack) {
        this.placeItemBlock(pos, stack, (item, block) -> block.m_49966_());
    }

    private void placeItemBlock(BlockPos pos, ItemStack stack, BiFunction<Item, Block, BlockState> function) {
        if (stack.m_41619_() && !(stack.m_41720_() instanceof BlockItem)) {
            return;
        }
        Block block = ((BlockItem)stack.m_41720_()).m_40614_();
        this.placeBlock(pos, function.apply(stack.m_41720_(), block));
        BlockItem.m_40582_((Level)this.level, null, (BlockPos)pos, (ItemStack)stack);
    }

    private boolean placeBlock(BlockPos pos, BlockState state) {
        return this.placeBlock(pos, state, 3);
    }

    private boolean placeBlock(BlockPos pos, BlockState state, int flag) {
        boolean blockSnapshotValue = this.level.captureBlockSnapshots;
        this.level.captureBlockSnapshots = false;
        boolean placed = this.level.m_7731_(pos, state, flag);
        this.level.captureBlockSnapshots = blockSnapshotValue;
        return placed;
    }

    private void destroyBlock(Player player, BlockPos pos, SimpleContainer inventory) {
        BlockState state = this.level.m_8055_(pos);
        int exp = state.getExpDrop((LevelReader)this.level, player.m_217043_(), pos, 0, 0);
        if (this.placeBlock(pos, Blocks.f_50016_.m_49966_()) && this.level instanceof ServerLevel) {
            Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, (BlockEntity)this.level.m_7702_(pos)).stream().map(arg_0 -> ((SimpleContainer)inventory).m_19173_(arg_0)).filter((Predicate<ItemStack>)Predicates.not(ItemStack::m_41619_)).forEach(stack -> Block.m_49840_((Level)this.level, (BlockPos)pos, (ItemStack)stack));
            state.m_222967_((ServerLevel)this.level, player.m_20183_(), ItemStack.f_41583_, true);
            if (exp > 0) {
                state.m_60734_().m_49805_((ServerLevel)this.level, player.m_20183_(), exp);
            }
        }
    }

    private List<ItemStack> extractItems(BlockTagItemStackHandler handler, Set<BlockPos> set) {
        return ItemHandlerUtil.extractItems((IItemHandler)handler, handler::getCondition, set.size());
    }

    private boolean hasEnoughItems(BlockTagItemStackHandler handler, Set<BlockPos> set) {
        return ItemHandlerUtil.getItemCount((IItemHandler)handler, handler::getCondition) >= set.size();
    }

    private int calculateCost() {
        int breakCount = (int)this.allPositionSet.stream().filter(Predicates.not(arg_0 -> ((Level)this.level).m_46859_(arg_0))).count();
        int placeCount = this.allPositionSet.size() - this.airSet.size();
        return breakCount * 2 + placeCount;
    }

    public Set<BlockPos> getAllPositionsSet() {
        return Collections.unmodifiableSet(this.allPositionSet);
    }

    public Set<BlockPos> getFirstRailPos() {
        return this.firstRailPos;
    }

    protected BlockPos addFirstRail(BlockPos pos) {
        this.firstRailPos.add(pos);
        return pos;
    }

    public static Optional<TrackBuilderManager> create(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode, boolean doubleTrack) {
        TrackBuilderManager manager;
        TrackBuilderManager trackBuilderManager = manager = doubleTrack ? new DoubleTrackBuilderManager(rayTracePos, rayTraceFace, level, lookVector, mode) : new SingleTrackBuilderManager(rayTracePos, rayTraceFace, level, lookVector, mode);
        if (manager.direction.m_122434_().m_122479_()) {
            manager.calculateBlockPosition();
            return Optional.of(manager);
        }
        return Optional.empty();
    }

    private static class DoubleTrackBuilderManager
    extends TrackBuilderManager {
        private DoubleTrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode) {
            super(rayTracePos, rayTraceFace, level, lookVector, mode);
        }

        @Override
        protected void calculate(Direction directionLeft, Direction directionRight) {
            BlockPos.m_121990_((BlockPos)this.addFirstRail(this.startPos.m_121945_(this.direction).m_121945_(directionLeft).m_7494_()), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_121945_(directionLeft).m_7494_()).map(BlockPos::m_7949_).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.m_5484_(this.direction, 9).m_121945_(directionLeft).m_7495_().m_7949_());
            BlockPos.m_121990_((BlockPos)this.addFirstRail(this.startPos.m_121945_(this.direction).m_121945_(directionRight).m_7494_()), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_121945_(directionRight).m_7494_()).map(BlockPos::m_7949_).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.m_5484_(this.direction, 9).m_121945_(directionRight).m_7495_().m_7949_());
            BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, 2), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, 2)).map(BlockPos::m_7949_).forEach(this.groundSet::add);
            BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, 2).m_7495_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, 2).m_6625_(2)).map(BlockPos::m_7949_).filter((Predicate<BlockPos>)Predicates.not(this.redstoneTorchSet::contains)).forEach(this.cobbleSet::add);
            if (this.mode.isFullTunnel()) {
                BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, 2).m_7494_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, 2).m_6630_(4)).map(BlockPos::m_7949_).forEach(this.airSet::add);
                BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, 3).m_7494_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, 3).m_6630_(5)).map(BlockPos::m_7949_).filter((Predicate<BlockPos>)Predicates.not(this.airSet::contains)).forEach(this.tunnelSet::add);
                this.torchSet.add(this.startPos.m_5484_(this.direction, 3).m_6630_(3).m_5484_(directionLeft, 2).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 7).m_6630_(3).m_5484_(directionLeft, 2).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 11).m_6630_(3).m_5484_(directionLeft, 2).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 15).m_6630_(3).m_5484_(directionLeft, 2).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 3).m_6630_(3).m_5484_(directionRight, 2).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 7).m_6630_(3).m_5484_(directionRight, 2).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 11).m_6630_(3).m_5484_(directionRight, 2).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 15).m_6630_(3).m_5484_(directionRight, 2).m_7949_());
                this.airSet.removeAll(this.torchSet);
                this.airSet.removeAll(this.railSet);
            } else if (!this.mode.isNoTunnel()) {
                BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, this.mode.getDistanceSide() + 1).m_7494_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, this.mode.getDistanceSide() + 1).m_6630_(this.mode.getDistanceUp())).map(BlockPos::m_7949_).filter((Predicate<BlockPos>)Predicates.not(this.railSet::contains)).forEach(this.airSet::add);
            }
        }
    }

    private static class SingleTrackBuilderManager
    extends TrackBuilderManager {
        private SingleTrackBuilderManager(BlockPos rayTracePos, Direction rayTraceFace, Level level, Vec3 lookVector, TrackBuilderMode mode) {
            super(rayTracePos, rayTraceFace, level, lookVector, mode);
        }

        @Override
        protected void calculate(Direction directionLeft, Direction directionRight) {
            BlockPos.m_121990_((BlockPos)this.addFirstRail(this.startPos.m_121945_(this.direction).m_7494_()), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_7494_()).map(BlockPos::m_7949_).forEach(this.railSet::add);
            this.redstoneTorchSet.add(this.startPos.m_5484_(this.direction, 9).m_7495_().m_7949_());
            BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_121945_(directionLeft), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_121945_(directionRight)).map(BlockPos::m_7949_).forEach(this.groundSet::add);
            BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_121945_(directionLeft).m_7495_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_121945_(directionRight).m_6625_(2)).map(BlockPos::m_7949_).filter((Predicate<BlockPos>)Predicates.not(this.redstoneTorchSet::contains)).forEach(this.cobbleSet::add);
            if (this.mode.isFullTunnel()) {
                BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, 1).m_7494_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, 1).m_6630_(4)).map(BlockPos::m_7949_).forEach(this.airSet::add);
                BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, 2).m_7494_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, 2).m_6630_(5)).map(BlockPos::m_7949_).filter((Predicate<BlockPos>)Predicates.not(this.airSet::contains)).forEach(this.tunnelSet::add);
                this.torchSet.add(this.startPos.m_5484_(this.direction, 5).m_6630_(3).m_5484_(directionLeft, 1).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 13).m_6630_(3).m_5484_(directionLeft, 1).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 5).m_6630_(3).m_5484_(directionRight, 1).m_7949_());
                this.torchSet.add(this.startPos.m_5484_(this.direction, 13).m_6630_(3).m_5484_(directionRight, 1).m_7949_());
                this.airSet.removeAll(this.torchSet);
                this.airSet.removeAll(this.railSet);
            } else if (!this.mode.isNoTunnel()) {
                BlockPos.m_121990_((BlockPos)this.startPos.m_121945_(this.direction).m_5484_(directionLeft, this.mode.getDistanceSide()).m_7494_(), (BlockPos)this.startPos.m_5484_(this.direction, 17).m_5484_(directionRight, this.mode.getDistanceSide()).m_6630_(this.mode.getDistanceUp())).map(BlockPos::m_7949_).filter((Predicate<BlockPos>)Predicates.not(this.railSet::contains)).forEach(this.airSet::add);
            }
        }
    }
}

