/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public abstract class FuelRecipe
implements Recipe<Container> {
    protected final Ingredient ingredient;
    protected final int fuel;
    protected final ResourceLocation id;
    protected final String group;

    public FuelRecipe(ResourceLocation id, String group, Ingredient ingredient, int fuel) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.fuel = fuel;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.ingredient.test(inv.m_8020_(0));
    }

    public int getFuel() {
        return this.fuel;
    }

    public static class Serializer<T extends FuelRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            int fuel = GsonHelper.m_13927_((JsonObject)json, (String)"fuel");
            return this.factory.create(id, group, ingredient, fuel);
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int fuel = buffer.readInt();
            return this.factory.create(id, group, ingredient, fuel);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130070_(((FuelRecipe)recipe).group);
            ((FuelRecipe)recipe).ingredient.m_43923_(buffer);
            buffer.writeInt(((FuelRecipe)recipe).fuel);
        }

        public static interface IFactory<T extends FuelRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, int var4);
        }
    }
}

