/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.useful_railroads.block.CustomAdvancedBlockEntityRailBlock;
import info.u_team.useful_railroads.blockentity.BufferStopBlockEntity;
import info.u_team.useful_railroads.init.UsefulRailroadsBlockEntityTypes;
import info.u_team.useful_railroads.util.ItemHandlerUtil;
import info.u_team.useful_railroads.util.VoxelShapeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BufferStopBlock
extends CustomAdvancedBlockEntityRailBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final Map<Direction, VoxelShape> VOXEL_SHAPES = BufferStopBlock.createVoxelShape();

    private static List<Pair<Vec3, Vec3>> createSideShapeVec(int bracketStart, int bracketEnd, int supportStart, int supportEnd, int stopperStart, int stopperEnd) {
        ArrayList<Pair<Vec3, Vec3>> list = new ArrayList<Pair<Vec3, Vec3>>();
        for (int i = 0; i < 10; ++i) {
            list.add(VoxelShapeUtil.createVectorPair(bracketStart, 2 + i, 14 - i, bracketEnd, 3 + i, 16 - i));
        }
        list.add(VoxelShapeUtil.createVectorPair(stopperStart, 11.0, 0.0, stopperEnd, 16.0, 1.0));
        list.add(VoxelShapeUtil.createVectorPair(supportStart, 2.0, 2.0, supportEnd, 14.0, 6.0));
        return list;
    }

    private static Map<Direction, VoxelShape> createVoxelShape() {
        ArrayList<Pair<Vec3, Vec3>> northShape = new ArrayList<Pair<Vec3, Vec3>>();
        northShape.addAll(BufferStopBlock.createSideShapeVec(2, 3, 2, 4, 0, 5));
        northShape.addAll(BufferStopBlock.createSideShapeVec(13, 14, 12, 14, 11, 16));
        northShape.add(VoxelShapeUtil.createVectorPair(0.0, 12.0, 1.0, 16.0, 15.0, 3.0));
        return VoxelShapeUtil.getHorizontalRotations(northShape).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, valueEntry -> Shapes.m_83124_((VoxelShape)f_49355_, (VoxelShape[])((VoxelShape[])VoxelShapeUtil.createVoxelShapeFromVector((List)valueEntry.getValue()).stream().toArray(VoxelShape[]::new)))));
    }

    public BufferStopBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60910_().m_60978_(1.5f).m_60918_(SoundType.f_56743_), (Supplier<? extends BlockEntityType<?>>)UsefulRailroadsBlockEntityTypes.BUFFER_STOP);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VOXEL_SHAPES.getOrDefault(state.m_61143_((Property)FACING), VOXEL_SHAPES.get(Direction.NORTH));
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        cart.m_20334_(0.0, 0.0, 0.0);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        if (!powered) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Vec3 vec = cart.m_20182_().m_82520_((double)direction.m_122429_() * 1.1, 0.0, (double)direction.m_122431_() * 1.1);
            cart.m_7678_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), cart.m_146908_(), cart.m_146909_());
        }
        if (level.f_46443_ || !powered) {
            return;
        }
        Optional tileEntityOptional = this.getBlockEntity((BlockGetter)level, pos);
        tileEntityOptional.ifPresent(bufferStop -> {
            cart.m_20153_();
            ArrayList drops = new ArrayList();
            cart.captureDrops(drops);
            cart.m_7617_(cart.m_269291_().m_269425_());
            drops.stream().map(ItemEntity::m_32055_).forEach(stack -> {
                ItemStack stackLeft = ItemHandlerHelper.insertItem((IItemHandler)bufferStop.getMinecartSlots(), (ItemStack)stack, (boolean)false);
                if (!stackLeft.m_41619_()) {
                    BufferStopBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stackLeft);
                }
                bufferStop.m_6596_();
            });
        });
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof AbstractMinecart) {
            Direction.AxisDirection axisDirection;
            AbstractMinecart cart = (AbstractMinecart)entity;
            Vec3 motion = cart.m_20184_();
            Direction oppositeDirection = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            Direction.Axis axis = oppositeDirection.m_122434_();
            if (this.isRightCollision(axis, Direction.Axis.X, axisDirection = oppositeDirection.m_122421_(), motion.m_7096_()) || this.isRightCollision(axis, Direction.Axis.Z, axisDirection, motion.m_7094_())) {
                return Shapes.m_83040_();
            }
        }
        return state.m_60808_(level, pos);
    }

    private final boolean isRightCollision(Direction.Axis axis, Direction.Axis axisToCheck, Direction.AxisDirection axisDirection, double motion) {
        return axis == axisToCheck && Math.abs(motion) > 0.01 && (axisDirection == Direction.AxisDirection.NEGATIVE && motion < 0.0 || axisDirection == Direction.AxisDirection.POSITIVE && motion > 0.0);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        boolean isWater = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SHAPE, (Comparable)(direction.m_122434_() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(isWater));
    }

    protected BlockState m_49367_(Level level, BlockPos pos, BlockState state, boolean placing) {
        return state;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            RailShape newShape = (RailShape)newState.m_61143_((Property)SHAPE);
            Direction newDirection = (Direction)newState.m_61143_((Property)FACING);
            if (newShape != state.m_61143_((Property)SHAPE)) {
                if (newDirection.m_122434_() == Direction.Axis.Z && newShape != RailShape.NORTH_SOUTH) {
                    level.m_46597_(pos, (BlockState)newState.m_61124_((Property)SHAPE, (Comparable)RailShape.NORTH_SOUTH));
                } else if (newDirection.m_122434_() == Direction.Axis.X && newShape != RailShape.EAST_WEST) {
                    level.m_46597_(pos, (BlockState)newState.m_61124_((Property)SHAPE, (Comparable)RailShape.EAST_WEST));
                }
            }
        } else {
            Optional tileEntityOptional = this.getBlockEntity((BlockGetter)level, pos);
            tileEntityOptional.map(BufferStopBlockEntity::getMinecartSlots).ifPresent(minecartSlots -> ItemHandlerUtil.getStackStream((IItemHandler)minecartSlots).forEach(stack -> BufferStopBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack)));
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.updatePower(level, state, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        this.updatePower(level, state, pos);
    }

    private void updatePower(Level level, BlockState state, BlockPos pos) {
        boolean powered = this.isPowered(level, pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    private boolean isPowered(Level level, BlockPos pos) {
        return Stream.of(Direction.values()).anyMatch(direction -> this.isPowered(level, pos, (Direction)direction));
    }

    private boolean isPowered(Level level, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.m_121945_(direction);
        int value = level.m_277185_(relativePos, direction);
        if (value >= 15) {
            return true;
        }
        BlockState relativeState = level.m_8055_(relativePos);
        return Math.max(value, relativeState.m_60734_() == Blocks.f_50088_ ? (Integer)relativeState.m_61143_((Property)RedStoneWireBlock.f_55500_) : 0) > 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return 0.0f;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean isFlexibleRail(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }
}

