/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartanundergarden;

import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import krelox.spartantoolkit.SpartanAddon;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponMap;
import krelox.spartantoolkit.WeaponType;
import krelox.spartanundergarden.trait.ChillTrait;
import krelox.spartanundergarden.trait.RotspawnDamageBonusTrait;
import krelox.spartanundergarden.trait.UndergardenDamageBonusTrait;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import quek.undergarden.registry.UGItemTiers;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGTags;

@Mod(value="spartanundergarden")
public class SpartanUndergarden
extends SpartanAddon {
    public static final String MODID = "spartanundergarden";
    public static final WeaponMap WEAPONS = new WeaponMap();
    public static final DeferredRegister<Item> ITEMS = SpartanUndergarden.itemRegister((String)"spartanundergarden");
    public static final DeferredRegister<WeaponTrait> TRAITS = SpartanUndergarden.traitRegister((String)"spartanundergarden");
    public static final DeferredRegister<CreativeModeTab> TABS = SpartanUndergarden.tabRegister((String)"spartanundergarden");
    public static final RegistryObject<WeaponTrait> CHILLY = SpartanUndergarden.registerTrait(TRAITS, (WeaponTrait)new ChillTrait());
    public static final RegistryObject<WeaponTrait> ROTSPAWN_DAMAGE_BONUS = SpartanUndergarden.registerTrait(TRAITS, (WeaponTrait)new RotspawnDamageBonusTrait().setMagnitude(1.5f));
    public static final RegistryObject<WeaponTrait> UNDERGARDEN_DAMAGE_BONUS = SpartanUndergarden.registerTrait(TRAITS, (WeaponTrait)new UndergardenDamageBonusTrait().setMagnitude(1.5f));
    public static final ArrayList<SpartanMaterial> MATERIALS = new ArrayList();
    public static final SpartanMaterial CLOGGRUM = SpartanUndergarden.material(UGItemTiers.CLOGGRUM, (TagKey<Item>)UGTags.Items.INGOTS_CLOGGRUM, new RegistryObject[0]);
    public static final SpartanMaterial FROSTSTEEL = SpartanUndergarden.material(UGItemTiers.FROSTSTEEL, (TagKey<Item>)UGTags.Items.INGOTS_FROSTSTEEL, CHILLY);
    public static final SpartanMaterial UTHERIUM = SpartanUndergarden.material(UGItemTiers.UTHERIUM, (TagKey<Item>)UGTags.Items.INGOTS_UTHERIUM, ROTSPAWN_DAMAGE_BONUS);
    public static final SpartanMaterial FORGOTTEN = SpartanUndergarden.material(UGItemTiers.FORGOTTEN, (TagKey<Item>)UGTags.Items.INGOTS_FORGOTTEN_METAL, UNDERGARDEN_DAMAGE_BONUS).setRarity(UGItems.FORGOTTEN);
    public static final RegistryObject<CreativeModeTab> SPARTAN_UNDERGARDEN_TAB = SpartanUndergarden.registerTab(TABS, (String)"spartanundergarden", () -> (Item)WEAPONS.get(FORGOTTEN, WeaponType.FLANGED_MACE).get(), (parameters, output) -> ITEMS.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get())));

    @SafeVarargs
    private static SpartanMaterial material(UGItemTiers tier, TagKey<Item> repairTag, RegistryObject<WeaponTrait> ... traits) {
        SpartanMaterial material = new SpartanMaterial(tier.name().toLowerCase(), MODID, (Tier)tier, repairTag, traits);
        MATERIALS.add(material);
        return material;
    }

    public SpartanUndergarden() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerSpartanWeapons(ITEMS);
        ITEMS.register(bus);
        TRAITS.register(bus);
        TABS.register(bus);
    }

    protected void addItemTags(ItemTagsProvider provider, Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag) {
        Function<SpartanMaterial, Item[]> func = material -> (Item[])WEAPONS.entrySet().stream().filter(entry -> ((SpartanMaterial)((Pair)entry.getKey()).first()).equals(material)).map(entry -> (Item)((RegistryObject)entry.getValue()).get()).toArray(Item[]::new);
        tag.apply((TagKey<Item>)UGTags.Items.CLOGGRUM_ITEMS).m_255179_((Object[])func.apply(CLOGGRUM));
        tag.apply((TagKey<Item>)UGTags.Items.FROSTSTEEL_ITEMS).m_255179_((Object[])func.apply(FROSTSTEEL));
        tag.apply((TagKey<Item>)UGTags.Items.UTHERIUM_ITEMS).m_255179_((Object[])func.apply(UTHERIUM));
    }

    protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        WEAPONS.forEach((key, item) -> {
            SpartanMaterial material = (SpartanMaterial)key.first();
            WeaponType type = (WeaponType)key.second();
            if (material.equals(FORGOTTEN)) {
                SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WEAPONS.get(CLOGGRUM, type).get()}), (Ingredient)Ingredient.m_204132_((TagKey)UGTags.Items.INGOTS_FORGOTTEN_METAL), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)item.get())).m_266439_("has_" + UGItems.FORGOTTEN_UPGRADE_TEMPLATE.getId().m_135815_(), (CriterionTriggerInstance)SpartanUndergarden.has((ItemLike)((ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get()))).m_266371_(consumer, item.getId().m_266382_("_smithing"));
            } else {
                type.recipe.accept((Object)WEAPONS, (Object)consumer, (Object)material);
            }
        });
    }

    public String modid() {
        return MODID;
    }

    public List<SpartanMaterial> getMaterials() {
        return MATERIALS;
    }

    public WeaponMap getWeaponMap() {
        return WEAPONS;
    }
}

