/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.server.goals;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;

public class ACExFollowNearestGoal<T extends LivingEntity>
extends Goal {
    protected final PathfinderMob mob;
    final Predicate<LivingEntity> followPredicate;
    protected Class<T> targetType;
    public final double speedModifier;
    private final float areaSize;
    public final PathNavigation navigation;
    public int timeToRecalcPath;

    public ACExFollowNearestGoal(PathfinderMob mob, Class<T> targetType, float areaSize, double speedModifier) {
        this(mob, targetType, areaSize, speedModifier, LivingEntity::m_6084_);
    }

    public ACExFollowNearestGoal(PathfinderMob mob, Class<T> targetType, float areaSize, double speedModifier, @Nullable Predicate<LivingEntity> followPredicate) {
        this.mob = mob;
        this.targetType = targetType;
        this.followPredicate = followPredicate;
        this.speedModifier = speedModifier;
        this.areaSize = areaSize;
        this.navigation = mob.m_21573_();
    }

    public boolean m_8036_() {
        return this.getTarget() != null;
    }

    public void m_8037_() {
        LivingEntity target = this.getTarget();
        if (target != null && !this.mob.m_21523_()) {
            this.mob.m_21563_().m_24960_((Entity)target, 10.0f, (float)this.mob.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.navigation.m_5624_((Entity)target, this.speedModifier);
            }
        } else {
            this.timeToRecalcPath = this.m_183277_(10);
            this.navigation.m_26573_();
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        Level level = this.mob.m_9236_();
        List targetList = level.m_6443_(this.targetType, this.mob.m_20191_().m_82400_((double)this.areaSize), this.followPredicate);
        if (targetList.isEmpty()) {
            return null;
        }
        return (LivingEntity)targetList.get(0);
    }
}

