/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.server.entity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearSirenBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearBombEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.google.common.base.Predicates;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PlayMessages;
import org.crimsoncrips.alexscavesexemplified.client.particle.ACExParticleRegistry;
import org.crimsoncrips.alexscavesexemplified.compat.ACEnrichedCompat;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.Gammafied;
import org.crimsoncrips.alexscavesexemplified.server.blocks.ACExBlockRegistry;
import org.crimsoncrips.alexscavesexemplified.server.entity.ACExEntityRegistry;

public class GammaNuclearBombEntity
extends NuclearBombEntity {
    private static final EntityDataAccessor<Integer> TIME = SynchedEntityData.m_135353_(GammaNuclearBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAX_TIME = 300;
    private boolean spawnedExplosion = false;

    public GammaNuclearBombEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public GammaNuclearBombEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACExEntityRegistry.GAMMA_NUCLEAR_BOMB.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ACExBlockRegistry.GAMMA_NUCLEAR_BOMB.get());
    }

    public void m_8119_() {
        int i;
        Level level;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.7, 0.7));
        }
        if ((this.f_19797_ + this.m_19879_()) % 10 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getNearbySirens(serverLevel, 384).forEach(this::activateSiren);
        }
        if ((i = this.getTime() + 1) > 300) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_ && !this.spawnedExplosion) {
                this.explode();
                this.spawnedExplosion = true;
            }
        } else {
            this.setTime(i);
            this.m_20073_();
            if (this.m_9236_().f_46443_ && 300 - i > 10 && this.f_19796_.m_188501_() < 0.3f && this.m_20096_()) {
                Vec3 center = this.m_146892_();
                this.m_9236_().m_7106_((ParticleOptions)ACExParticleRegistry.GAMMA_PROTON.get(), center.f_82479_, center.f_82480_, center.f_82481_, center.f_82479_, center.f_82480_, center.f_82481_);
            }
        }
    }

    private void explode() {
        if (ModList.get().isLoaded("alexscavesenriched") && ACEnrichedCompat.config()) {
            ACEnrichedCompat.summonNuclearExplosion2(this.m_9236_(), (Entity)this);
        } else {
            NuclearExplosionEntity vanillaNuke = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(this.m_9236_());
            vanillaNuke.setSize(((Double)AlexsCaves.COMMON_CONFIG.nukeExplosionSizeModifier.get()).floatValue() * 1.5f);
            ((Gammafied)vanillaNuke).setGamma(true);
            vanillaNuke.m_20359_((Entity)this);
            this.m_9236_().m_7967_((Entity)vanillaNuke);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(Tags.Items.SHEARS)) {
            ACExUtils.awardOutsideAdvancement((Entity)player, "alexscaves/defuse_nuclear_bomb", "interact", "alexscaves");
            player.m_6674_(hand);
            this.m_216990_((SoundEvent)ACSoundRegistry.NUCLEAR_BOMB_DEFUSE.get());
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_19983_(new ItemStack((ItemLike)ACExBlockRegistry.GAMMA_NUCLEAR_BOMB.get()));
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            ACExUtils.awardOutsideAdvancement((Entity)player, "alexscaves/ride_nuclear_bomb", "ride_a_boat_with_a_goat", "alexscaves");
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private Stream<BlockPos> getNearbySirens(ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.NUCLEAR_SIREN.getKey()), (Predicate)Predicates.alwaysTrue(), this.m_20183_(), range, PoiManager.Occupancy.ANY);
    }

    private void activateSiren(BlockPos pos) {
        BlockEntity var3 = this.m_9236_().m_7702_(pos);
        if (var3 instanceof NuclearSirenBlockEntity) {
            NuclearSirenBlockEntity nuclearSirenBlock = (NuclearSirenBlockEntity)var3;
            nuclearSirenBlock.setNearestNuclearBomb((Entity)this);
        }
    }
}

