/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.server.blocks.cauldron;

import com.github.alexmodguy.alexscaves.server.item.HazmatArmorItem;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.crimsoncrips.alexscavesexemplified.server.blocks.cauldron.ACExCauldron;
import org.crimsoncrips.alexscavesexemplified.server.blocks.cauldron.ACExCauldronInteraction;

public class AcidCauldronBlock
extends ACExCauldron {
    public AcidCauldronBlock(BlockBehaviour.Properties p_153498_) {
        super(p_153498_, ACExCauldronInteraction.ACID);
    }

    @Override
    protected double getContentHeight(BlockState p_153500_) {
        return 0.9375;
    }

    public void m_7892_(BlockState p_153506_, Level p_153507_, BlockPos p_153508_, Entity p_153509_) {
        if (this.isEntityInsideContent(p_153506_, p_153508_, p_153509_)) {
            boolean armor = false;
            boolean hurtSound = false;
            float dmgMultiplier = 1.0f;
            if (p_153509_ instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)p_153509_;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    Player player;
                    ItemStack item;
                    if (!slot.m_254934_() || (item = living.m_6844_(slot)) == null || !item.m_41763_() || item.m_41720_() instanceof HazmatArmorItem) continue;
                    armor = true;
                    if (!(living.m_217043_().m_188501_() < 0.05f) || p_153509_ instanceof Player && (player = (Player)p_153509_).m_7500_()) continue;
                    item.m_41622_(1, living, e -> e.m_21166_(slot));
                }
                dmgMultiplier = 1.0f - (float)HazmatArmorItem.getWornAmount((LivingEntity)living) / 4.0f;
            }
            if (armor) {
                ACAdvancementTriggerRegistry.ENTER_ACID_WITH_ARMOR.triggerForEntity(p_153509_);
            }
            if (p_153507_.f_46441_.m_188501_() < dmgMultiplier) {
                float golemAddition = p_153509_.m_6095_().m_204039_(ACTagRegistry.WEAK_TO_ACID) ? 10.0f : 0.0f;
                hurtSound = p_153509_.m_6469_(ACDamageTypes.causeAcidDamage((RegistryAccess)p_153507_.m_9598_()), dmgMultiplier * (float)(armor ? 0.01 : 1.0) + golemAddition);
            }
            if (hurtSound) {
                p_153509_.m_216990_((SoundEvent)ACSoundRegistry.ACID_BURN.get());
            }
        }
    }

    public int m_6782_(BlockState p_153502_, Level p_153503_, BlockPos p_153504_) {
        return 3;
    }
}

