/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.server.blocks.cauldron;

import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.server.blocks.ACExBlockRegistry;

public interface ACExCauldronInteraction {
    public static final Map<Item, ACExCauldronInteraction> EMPTY = ACExCauldronInteraction.newInteractionMap();
    public static final Map<Item, ACExCauldronInteraction> ACID = ACExCauldronInteraction.newInteractionMap();
    public static final Map<Item, ACExCauldronInteraction> PURPLE_SODA = ACExCauldronInteraction.newInteractionMap();
    public static final ACExCauldronInteraction FILL_ACID = (p_175676_, p_175677_, p_175678_, p_175679_, p_175680_, p_175681_) -> ACExCauldronInteraction.emptyBucket(p_175677_, p_175678_, p_175679_, p_175680_, p_175681_, ((Block)ACExBlockRegistry.ACID_CAULDRON.get()).m_49966_(), (SoundEvent)ACSoundRegistry.ACID_CORROSION.get());
    public static final ACExCauldronInteraction FILL_SODA = (p_175676_, p_175677_, p_175678_, p_175679_, p_175680_, p_175681_) -> ACExCauldronInteraction.emptyBucket(p_175677_, p_175678_, p_175679_, p_175680_, p_175681_, ((Block)ACExBlockRegistry.PURPLE_SODA_CAULDRON.get()).m_49966_(), (SoundEvent)ACSoundRegistry.PURPLE_SODA_SWIM.get());

    public static Object2ObjectOpenHashMap<Item, ACExCauldronInteraction> newInteractionMap() {
        return (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), p_175646_ -> p_175646_.defaultReturnValue((p_175739_, p_175740_, p_175741_, p_175742_, p_175743_, p_175744_) -> InteractionResult.PASS));
    }

    public InteractionResult interact(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, ItemStack var6);

    public static void bootStrap() {
        ACExCauldronInteraction.addDefaultInteractions(EMPTY);
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.LIQUID_REPLICATION_ENABLED.get()).booleanValue()) {
            EMPTY.put((Item)ACItemRegistry.PURPLE_SODA_BOTTLE.get(), (p_175732_, p_175733_, p_175734_, p_175735_, p_175736_, p_175737_) -> {
                if (!p_175733_.f_46443_) {
                    p_175735_.m_21008_(p_175736_, ItemUtils.m_41813_((ItemStack)p_175737_, (Player)p_175735_, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    p_175735_.m_36220_(Stats.f_12944_);
                    p_175735_.m_36246_(Stats.f_12982_.m_12902_((Object)p_175737_.m_41720_()));
                    ACExUtils.awardAdvancement((Entity)p_175735_, "soda_replication", "replicate");
                    p_175733_.m_46597_(p_175734_, ((Block)ACExBlockRegistry.PURPLE_SODA_CAULDRON.get()).m_49966_());
                    p_175733_.m_5594_((Player)null, p_175734_, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    p_175733_.m_142346_((Entity)null, GameEvent.f_157769_, p_175734_);
                }
                return InteractionResult.m_19078_((boolean)p_175733_.f_46443_);
            });
        }
        ACID.put(Items.f_42446_, (p_175697_, p_175698_, p_175699_, p_175700_, p_175701_, p_175702_) -> ACExCauldronInteraction.fillBucket(p_175697_, p_175698_, p_175699_, p_175700_, p_175701_, p_175702_, new ItemStack((ItemLike)ACItemRegistry.ACID_BUCKET.get()), p_175651_ -> true, (SoundEvent)ACSoundRegistry.ACID_SUBMERGE.get()));
        ACExCauldronInteraction.addDefaultInteractions(ACID);
        PURPLE_SODA.put(Items.f_42446_, (p_175697_, p_175698_, p_175699_, p_175700_, p_175701_, p_175702_) -> ACExCauldronInteraction.fillBucket(p_175697_, p_175698_, p_175699_, p_175700_, p_175701_, p_175702_, new ItemStack((ItemLike)ACItemRegistry.PURPLE_SODA_BUCKET.get()), p_175651_ -> true, (SoundEvent)ACSoundRegistry.PURPLE_SODA_SUBMERGE.get()));
        PURPLE_SODA.put(Items.f_42590_, (p_175697_, p_175698_, p_175699_, p_175700_, p_175701_, p_175702_) -> ACExCauldronInteraction.fillBucket(p_175697_, p_175698_, p_175699_, p_175700_, p_175701_, p_175702_, new ItemStack((ItemLike)ACItemRegistry.PURPLE_SODA_BOTTLE.get()), p_175651_ -> true, (SoundEvent)ACSoundRegistry.PURPLE_SODA_SUBMERGE.get()));
        ACExCauldronInteraction.addDefaultInteractions(PURPLE_SODA);
    }

    public static void addDefaultInteractions(Map<Item, ACExCauldronInteraction> pInteractionsMap) {
        pInteractionsMap.put((Item)ACItemRegistry.ACID_BUCKET.get(), FILL_ACID);
        pInteractionsMap.put((Item)ACItemRegistry.PURPLE_SODA_BUCKET.get(), FILL_SODA);
    }

    public static InteractionResult fillBucket(BlockState pBlockState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack pEmptyStack, ItemStack pFilledStack, Predicate<BlockState> pStatePredicate, SoundEvent pFillSound) {
        if (!pStatePredicate.test(pBlockState)) {
            return InteractionResult.PASS;
        }
        if (!pLevel.f_46443_) {
            Item item = pEmptyStack.m_41720_();
            pPlayer.m_21008_(pHand, ItemUtils.m_41813_((ItemStack)pEmptyStack, (Player)pPlayer, (ItemStack)pFilledStack));
            pPlayer.m_36220_(Stats.f_12944_);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            pLevel.m_46597_(pPos, ((Block)ACExBlockRegistry.METAL_CAULDRON.get()).m_49966_());
            pLevel.m_5594_((Player)null, pPos, pFillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_142346_((Entity)null, GameEvent.f_157816_, pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public static InteractionResult emptyBucket(Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, ItemStack pFilledStack, BlockState pState, SoundEvent pEmptySound) {
        if (!pLevel.f_46443_) {
            Item item = pFilledStack.m_41720_();
            pPlayer.m_21008_(pHand, ItemUtils.m_41813_((ItemStack)pFilledStack, (Player)pPlayer, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            pPlayer.m_36220_(Stats.f_12943_);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            pLevel.m_46597_(pPos, pState);
            pLevel.m_5594_((Player)null, pPos, pEmptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_142346_((Entity)null, GameEvent.f_157769_, pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }
}

