/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.server.blocks;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.CavePaintingBlock;
import com.github.alexmodguy.alexscaves.server.item.BlockItemWithSupplierLore;
import com.github.alexthe666.citadel.item.BlockItemWithSupplier;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.crimsoncrips.alexscavesexemplified.server.blocks.ACExGammaNuke;
import org.crimsoncrips.alexscavesexemplified.server.blocks.cauldron.AcidCauldronBlock;
import org.crimsoncrips.alexscavesexemplified.server.blocks.cauldron.MetalCauldronBlock;
import org.crimsoncrips.alexscavesexemplified.server.blocks.cauldron.PurpleSodaCauldronBlock;
import org.crimsoncrips.alexscavesexemplified.server.item.ACExItemRegistry;

public class ACExBlockRegistry {
    public static final DeferredRegister<Block> DEF_REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"alexscavesexemplified");
    public static final Rarity RARITY_GAMMA = Rarity.create((String)"alexscavesexemplified:gamma", (ChatFormatting)ChatFormatting.AQUA);
    public static final RegistryObject<Block> METAL_CAULDRON = ACExBlockRegistry.registerBlockAndItem("metal_cauldron", () -> new MetalCauldronBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(ACSoundTypes.SCRAP_METAL).m_60955_()));
    public static final RegistryObject<Block> GAMMA_NUCLEAR_BOMB = ACExBlockRegistry.registerBlockAndItemAnomaly("gamma_nuclear_bomb", () -> new ACExGammaNuke(), RARITY_GAMMA);
    public static final RegistryObject<Block> ACID_CAULDRON = DEF_REG.register("acid_cauldron", () -> new AcidCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)METAL_CAULDRON.get())).m_60953_(p_50870_ -> 13)));
    public static final RegistryObject<Block> PURPLE_SODA_CAULDRON = DEF_REG.register("purple_soda_cauldron", () -> new PurpleSodaCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)METAL_CAULDRON.get()))));
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_1 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_1", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_2 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_2", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_3 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_3", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_4 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_4", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_5 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_5", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_6 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_6", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_7 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_7", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_8 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_8", CavePaintingBlock::new);
    public static final RegistryObject<Block> CAVE_PAINTING_SACRIFICE_9 = ACExBlockRegistry.registerBlockAndItemLored("cave_painting_sacrifice_9", CavePaintingBlock::new);

    private static RegistryObject<Block> registerBlockAndItem(String name, Supplier<Block> block) {
        RegistryObject blockObj = DEF_REG.register(name, block);
        ACExItemRegistry.DEF_REG.register(name, () -> new BlockItemWithSupplier(blockObj, new Item.Properties()));
        return blockObj;
    }

    private static RegistryObject<Block> registerBlockAndItemAnomaly(String name, Supplier<Block> block, Rarity rarity) {
        RegistryObject blockObj = DEF_REG.register(name, block);
        ACExItemRegistry.DEF_REG.register(name, () -> new BlockItemWithSupplierLore(blockObj, new Item.Properties().m_41497_(rarity)));
        return blockObj;
    }

    private static RegistryObject<Block> registerBlockAndItemLored(String name, Supplier<Block> block) {
        RegistryObject blockObj = DEF_REG.register(name, block);
        ACExItemRegistry.DEF_REG.register(name, () -> new BlockItemWithSupplierLore(blockObj, new Item.Properties()));
        return blockObj;
    }
}

