/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.underzealot;

import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GloomothEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VesperEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.compat.AMCompat;
import org.crimsoncrips.alexscavesexemplified.compat.CuriosCompat;
import org.crimsoncrips.alexscavesexemplified.datagen.loottables.ACExLootTables;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExMobTargetClosePlayers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={UnderzealotEntity.class})
public abstract class ACExUnderzealotMixin
extends Monster {
    protected ACExUnderzealotMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$registerGoals(CallbackInfo ci) {
        final UnderzealotEntity underzealot = (UnderzealotEntity)this;
        underzealot.f_21346_.m_25352_(2, (Goal)new ACExMobTargetClosePlayers((Mob)underzealot, 40, 12.0f, livingEntity -> {
            boolean light = !CuriosCompat.hasLight(livingEntity) || (Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get() == false;
            boolean respect = !livingEntity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ACItemRegistry.CLOAK_OF_DARKNESS.get()) && !livingEntity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ACItemRegistry.HOOD_OF_DARKNESS.get()) || (Boolean)AlexsCavesExemplified.COMMON_CONFIG.UNDERZEALOT_RESPECT_ENABLED.get() == false;
            return light && respect;
        }){

            @Override
            public boolean m_8036_() {
                return !underzealot.isTargetingBlocked() && super.m_8036_();
            }
        });
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        LivingEntity target = this.m_5448_();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get()).booleanValue() && target != null && target != this.m_21188_() && CuriosCompat.hasLight(target)) {
            this.m_6710_(null);
            ACExUtils.awardAdvancement((Entity)target, "light_repel", "repelled");
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand pHand) {
        boolean respect;
        UnderzealotEntity underzealot = (UnderzealotEntity)this;
        Level level = this.m_9236_();
        boolean bl = respect = player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ACItemRegistry.CLOAK_OF_DARKNESS.get()) && player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ACItemRegistry.HOOD_OF_DARKNESS.get());
        if (underzealot.m_20197_().isEmpty() && !underzealot.isPraying() && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.DARK_OFFERING_ENABLED.get()).booleanValue()) {
            for (Mob leashedEntities : level.m_45976_(Mob.class, player.m_20191_().m_82400_(10.0))) {
                boolean happy;
                boolean lasso;
                boolean bl2 = lasso = ModList.get().isLoaded("alexsmobs") && AMCompat.isLeashed((LivingEntity)leashedEntities, player);
                if (leashedEntities.m_21524_() != player && !lasso || !(leashedEntities instanceof UnderzealotSacrifice) || underzealot.m_5448_() == player || leashedEntities.getPersistentData().m_128471_("SacrificeGiven")) continue;
                int tradeDeterminer = 0;
                if (leashedEntities instanceof GloomothEntity) {
                    tradeDeterminer = 1;
                    ACExUtils.awardAdvancement((Entity)player, "gloomoth_trade", "gloomoth");
                } else if (leashedEntities instanceof CorrodentEntity) {
                    tradeDeterminer = 2;
                    ACExUtils.awardAdvancement((Entity)player, "corrodent_trade", "corrodent");
                } else if (leashedEntities instanceof VesperEntity) {
                    tradeDeterminer = 3;
                    ACExUtils.awardAdvancement((Entity)player, "vesper_trade", "vesper");
                }
                if (lasso) {
                    leashedEntities.m_19983_(new ItemStack((ItemLike)AMCompat.amItemRegistry(1)));
                    AMCompat.vineLassoTo(null, (LivingEntity)leashedEntities);
                } else {
                    leashedEntities.m_21455_(true, true);
                }
                leashedEntities.getPersistentData().m_128379_("SacrificeGiven", true);
                if (!leashedEntities.m_9236_().m_5776_()) {
                    leashedEntities.m_20329_((Entity)underzealot);
                }
                if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.UNDERZEALOT_RESPECT_ENABLED.get()).booleanValue() && respect) {
                    ACExUtils.awardAdvancement((Entity)player, "dark_respect", "respect");
                    ResourceLocation resourceLocation = switch (tradeDeterminer) {
                        case 1 -> ACExLootTables.GLOOMOTH_TRADE;
                        case 2 -> ACExLootTables.CORRODENT_TRADE;
                        default -> ACExLootTables.VESPER_TRADE;
                    };
                    ACExUtils.spawnLoot(resourceLocation, (LivingEntity)underzealot, (Entity)player, 0);
                    happy = true;
                } else {
                    happy = false;
                }
                for (int i = 0; i < 5; ++i) {
                    double d0 = underzealot.m_217043_().m_188583_() * 0.02;
                    double d1 = underzealot.m_217043_().m_188583_() * 0.02;
                    double d2 = underzealot.m_217043_().m_188583_() * 0.02;
                    underzealot.m_9236_().m_7106_((ParticleOptions)(happy ? ParticleTypes.f_123748_ : ParticleTypes.f_123792_), underzealot.m_20208_(1.0), underzealot.m_20187_() + 1.0, underzealot.m_20262_(1.0), d0, d1, d2);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, pHand);
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=12)})
    private boolean alexsCavesExemplified$nearestAttack(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get() == false && (Boolean)AlexsCavesExemplified.COMMON_CONFIG.UNDERZEALOT_RESPECT_ENABLED.get() == false;
    }
}

