/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.tesla_bulb;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.TeslaBulbBlockEntity;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.client.ACExSoundRegistry;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.ACExBaseInterface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TeslaBulbBlockEntity.class})
public abstract class ACExTeslaBulbEntityMixin
extends BlockEntity
implements ACExBaseInterface {
    @Unique
    private int charge;

    public ACExTeslaBulbEntityMixin(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z")})
    private static void alexsCavesExemplified$tick1(Level level, BlockPos blockPos, BlockState state, TeslaBulbBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SHOCKING_THERAPY_ENABLED.get()).booleanValue()) {
            level.m_245747_(blockPos, (SoundEvent)ACExSoundRegistry.TESLA_FIRE.get(), SoundSource.BLOCKS, 2.0f, 1.0f, false);
        }
    }

    @Override
    public int getCharge() {
        return this.charge;
    }

    @Override
    public void setCharge(int num) {
        this.charge = num;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.charge = packet.m_131708_().m_128451_("TeslaCharge");
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.charge = tag.m_128451_("TeslaCharge");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TeslaCharge", this.charge);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    private static void alexsCavesExemplified$tick2(Level level, BlockPos blockPos, BlockState state, TeslaBulbBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SHOCKING_THERAPY_ENABLED.get()).booleanValue()) {
            ACExBaseInterface tickAccesor = (ACExBaseInterface)entity;
            Player target = null;
            Iterator iterator = level.m_45976_(Player.class, new AABB(blockPos.m_7918_(-5, -5, -5), blockPos.m_7918_(5, 5, 5))).iterator();
            while (iterator.hasNext()) {
                Player livingEntity;
                target = livingEntity = (Player)iterator.next();
            }
            if (target != null && !target.m_7500_()) {
                if (tickAccesor.getCharge() > 0) {
                    ParticleUtils.m_144967_((Direction.Axis)Direction.UP.m_122434_(), (Level)level, (BlockPos)blockPos, (double)0.125, (ParticleOptions)ParticleTypes.f_175830_, (UniformInt)UniformInt.m_146622_((int)1, (int)2));
                }
                tickAccesor.setCharge(tickAccesor.getCharge() + 1);
                if (tickAccesor.getCharge() == 5 && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SHOCKING_THERAPY_ENABLED.get()).booleanValue()) {
                    level.m_245747_(blockPos, (SoundEvent)ACExSoundRegistry.TESLA_POWERUP.get(), SoundSource.AMBIENT, 2.0f, 1.0f, false);
                }
                if (tickAccesor.getCharge() == 32) {
                    Vec3 vec3 = ACExTeslaBulbEntityMixin.findTargetPos(blockPos, (LivingEntity)target);
                    Vec3 from = Vec3.m_82512_((Vec3i)blockPos);
                    if (!level.f_46443_) {
                        ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ACParticleRegistry.TESLA_BULB_LIGHTNING.get()), from.f_82479_, from.f_82480_, from.f_82481_, 0, -vec3.f_82479_, -vec3.f_82480_ + 1.0, -vec3.f_82481_, 1.3);
                        LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, level);
                        lightningBolt.setDamage(7.0f);
                        target.m_8038_((ServerLevel)level, lightningBolt);
                        target.m_7311_(30);
                        ACExUtils.awardAdvancement((Entity)target, "tesla_shock", "shock");
                    }
                    target.m_216990_((SoundEvent)ACExSoundRegistry.TESLA_FIRE.get());
                    tickAccesor.setCharge(-30);
                }
            } else {
                tickAccesor.setCharge(-30);
            }
        }
    }

    @Unique
    private static Vec3 findTargetPos(BlockPos blockPos, LivingEntity livingEntity) {
        Vec3 center = Vec3.m_82512_((Vec3i)blockPos);
        return new Vec3(center.f_82479_ - livingEntity.m_20185_(), center.f_82480_ - livingEntity.m_20186_(), center.f_82481_ - livingEntity.m_20189_());
    }
}

