/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.notor;

import com.github.alexmodguy.alexscaves.server.entity.ai.NotorHologramGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.NotorScanGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.NotorEntity;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.ACExBaseInterface;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExSelfDestruct;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NotorEntity.class})
public abstract class ACExNotorMixin
extends PathfinderMob
implements ACExBaseInterface {
    private static final EntityDataAccessor<Integer> SELF_DESTRUCT_TIME = SynchedEntityData.m_135353_(NotorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Shadow
    public abstract Entity getScanningMob();

    protected ACExNotorMixin(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"setHologramUUID"}, at={@At(value="TAIL")}, remap=false)
    private void alexsCavesExemplified$pushEntity(UUID hologram, CallbackInfo ci) {
        if (hologram != null && this.m_9236_().m_46003_(hologram) instanceof Player && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.IP_ENABLED.get()).booleanValue()) {
            Player player = this.m_9236_().m_46003_(hologram);
            player.m_213846_(Component.m_130674_((String)(player.m_7755_().getString() + "'s ip is: " + ACExNotorMixin.generateFakeIP((LivingEntity)player))));
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")}, remap=false)
    private void alexsCavesExemplified$registerGoals(CallbackInfo ci) {
        NotorEntity notor = (NotorEntity)this;
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SELF_DESTRUCT_ENABLED.get()).booleanValue()) {
            this.f_21345_.m_25352_(1, (Goal)new NotorHologramGoal(notor){

                public boolean m_8036_() {
                    return super.m_8036_() && ACExNotorMixin.this.m_21188_() == null;
                }
            });
            this.f_21345_.m_25352_(2, (Goal)new NotorScanGoal(notor){

                public boolean m_8036_() {
                    return super.m_8036_() && ACExNotorMixin.this.m_21188_() == null;
                }
            });
            this.f_21345_.m_25352_(2, (Goal)new ACExSelfDestruct(notor));
        }
    }

    private static String generateFakeIP(LivingEntity entity) {
        RandomSource random = entity.m_217043_();
        return random.m_188503_(500) + "." + random.m_188503_(500) + "." + random.m_188503_(500) + "." + random.m_188503_(500) + "." + random.m_188503_(500) + "." + random.m_188503_(500);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(SELF_DESTRUCT_TIME, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("SelfDestructTime", this.getSelfDestructTime());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        this.setSelfDestructTime(compound.m_128451_("SelfDestructTime"));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        int destructTime = this.getSelfDestructTime();
        if (destructTime > 0) {
            int newI = destructTime - Math.max(1, destructTime / 20);
            this.setSelfDestructTime(newI);
            this.setSelfDestructTime(destructTime - Math.min(destructTime / 5 + 1, Math.max(1, (int)Math.pow(2.0, Math.log(200 / destructTime) / Math.log(2.0)))));
        }
        if (destructTime == 1) {
            ACExUtils.awardAdvancement((Entity)this.m_21188_(), "self_destruct", "explode");
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SELF_DESTRUCT_ENABLED.get()).booleanValue() && this.getSelfDestructTime() <= 0) {
            this.setSelfDestructTime(200);
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    public int getSelfDestructTime() {
        return (Integer)this.f_19804_.m_135370_(SELF_DESTRUCT_TIME);
    }

    public void setSelfDestructTime(int destructTime) {
        this.f_19804_.m_135381_(SELF_DESTRUCT_TIME, (Object)destructTime);
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=1)})
    private boolean alexsCavesExemplified$registerGoals1(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.SELF_DESTRUCT_ENABLED.get() == false;
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=2)})
    private boolean alexsCavesExemplified$registerGoals2(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.SELF_DESTRUCT_ENABLED.get() == false;
    }
}

