/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.magnetron;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronPartEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.MagnetronMagneticism;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MagnetronEntity.class})
public abstract class ACExMagnetronMixin
extends Monster
implements MagnetronMagneticism {
    @Shadow
    @Final
    public MagnetronPartEntity[] allParts;
    int delay = 0;
    private static final EntityDataAccessor<Integer> RIPPED_HEART = SynchedEntityData.m_135353_(MagnetronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Shadow
    public abstract boolean isFormed();

    protected ACExMagnetronMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public int getRippedHeart() {
        return (Integer)this.f_19804_.m_135370_(RIPPED_HEART);
    }

    @Override
    public void setRippedHeart(int value) {
        this.delay = 15;
        this.f_19804_.m_135381_(RIPPED_HEART, (Object)value);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(RIPPED_HEART, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("RippedHeart", this.getRippedHeart());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        this.setRippedHeart(compound.m_128451_("RippedHeart"));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        --this.delay;
        if (this.delay <= 0 && this.getRippedHeart() > 0) {
            this.setRippedHeart(0);
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        if (this.getRippedHeart() >= 100 && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.MAGNETICISM_ENABLED.get()).booleanValue()) {
            float range = 5.0f;
            Level level = this.m_9236_();
            Vec3 particlesFrom = this.m_20182_().m_82520_(0.0, 0.2, 0.0);
            float particleMax = 10 + this.m_217043_().m_188503_(5);
            int particles = 0;
            while ((float)particles < particleMax) {
                Vec3 vec3 = new Vec3(((double)this.m_217043_().m_188501_() - 0.5) * (double)0.3f, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.3f, (double)(range * 0.5f + range * 0.5f * this.m_217043_().m_188501_())).m_82524_((float)((double)((float)particles / particleMax) * Math.PI * 2.0)).m_82549_(particlesFrom);
                if (this.m_217043_().m_188499_()) {
                    level.m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, particlesFrom.f_82479_, particlesFrom.f_82480_, particlesFrom.f_82481_);
                } else {
                    level.m_7106_((ParticleOptions)ACParticleRegistry.AZURE_SHIELD_LIGHTNING.get(), particlesFrom.f_82479_, particlesFrom.f_82480_, particlesFrom.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                ++particles;
            }
            level.m_255391_(null, (double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, 1.0f, false, Level.ExplosionInteraction.NONE);
            if (this.isFormed()) {
                for (MagnetronPartEntity part : this.allParts) {
                    if (part.getBlockState() == null || !this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) continue;
                    BlockPos placeAt = part.m_20183_();
                    while (!this.m_9236_().m_8055_(placeAt).m_60795_() && placeAt.m_123342_() < this.m_9236_().m_151558_()) {
                        placeAt = placeAt.m_7494_();
                    }
                    FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)placeAt, (BlockState)part.getBlockState());
                    part.setBlockState(null);
                }
            }
        }
        super.m_6667_(pDamageSource);
    }
}

