/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.misc;

import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.FrostmintSpearEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.SpinningPeppermintEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.SugarStaffHexEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.SeaStaffItem;
import com.github.alexmodguy.alexscaves.server.item.SugarStaffItem;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SugarStaffItem.class})
public abstract class ACExSugarStaffMixin
extends Item {
    public ACExSugarStaffMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void alexsCavesExemplified$use(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)ACItemRegistry.RADIANT_ESSENCE.get()) && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.RADIANT_WRATH_ENABLED.get()).booleanValue()) {
            cir.cancel();
            boolean hex = player.m_6144_();
            player.m_6674_(hand);
            Entity lookingAtEntity = SeaStaffItem.getClosestLookingAtEntityFor((Level)level, (Player)player, (double)32.0);
            if (hex) {
                int humunguous = itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.HUMUNGOUS_HEX.get());
                float maxDist = 128.0f;
                HitResult realHitResult = ProjectileUtil.m_278180_((Entity)player, Entity::m_271807_, (double)maxDist);
                if (realHitResult.m_6662_() == HitResult.Type.MISS) {
                    realHitResult = ProjectileUtil.m_278180_((Entity)player, Entity::m_271807_, (double)42.0);
                }
                BlockPos.MutableBlockPos mutableSkyPos = new BlockPos.MutableBlockPos(realHitResult.m_82450_().f_82479_, realHitResult.m_82450_().f_82480_ + 1.5, realHitResult.m_82450_().f_82481_);
                int maxFallHeight = 15;
                for (int k = 0; mutableSkyPos.m_123342_() < level.m_151558_() && level.m_46859_((BlockPos)mutableSkyPos) && k < maxFallHeight; ++k) {
                    mutableSkyPos = mutableSkyPos.m_7494_();
                    ++k;
                }
                int maxSpears = 20 + (humunguous <= 0 ? 0 : 10 * humunguous + 1);
                for (int j = 0; j < maxSpears; ++j) {
                    FrostmintSpearEntity frostmintSpearEntity = (FrostmintSpearEntity)((EntityType)ACEntityRegistry.FROSTMINT_SPEAR.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)0.0, (double)0.0, (double)0.0), MobSpawnType.MOB_SUMMONED);
                    if (frostmintSpearEntity == null) continue;
                    frostmintSpearEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    frostmintSpearEntity.m_36781_(frostmintSpearEntity.m_36789_() * 2.0);
                    Vec3 vec3 = mutableSkyPos.m_252807_().m_82520_((double)(level.f_46441_.m_188501_() * 16.0f - 8.0f), (double)(level.f_46441_.m_188501_() * 4.0f - 2.0f), (double)(level.f_46441_.m_188501_() * 16.0f - 8.0f));
                    for (int clearTries = 0; clearTries < 6 && !level.m_46859_(BlockPos.m_274446_((Position)vec3)) && level.m_6425_(BlockPos.m_274446_((Position)vec3)).m_76178_(); ++clearTries) {
                        vec3 = mutableSkyPos.m_252807_().m_82520_((double)(level.f_46441_.m_188501_() * 16.0f - 8.0f), (double)(level.f_46441_.m_188501_() * 4.0f - 2.0f), (double)(level.f_46441_.m_188501_() * 16.0f - 8.0f));
                    }
                    if (!level.m_46859_(BlockPos.m_274446_((Position)vec3)) && level.m_6425_(BlockPos.m_274446_((Position)vec3)).m_76178_()) {
                        vec3 = mutableSkyPos.m_252807_();
                    }
                    frostmintSpearEntity.m_146884_(vec3);
                    Vec3 vec31 = realHitResult.m_82450_().m_82546_(vec3);
                    frostmintSpearEntity.m_6686_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 0.5f + 1.5f * level.f_46441_.m_188501_(), level.f_46441_.m_188501_() * 10.0f);
                    frostmintSpearEntity.getPersistentData().m_128379_("FrostRadiant", true);
                }
                SugarStaffHexEntity sugarStaffHexEntity = (SugarStaffHexEntity)((EntityType)ACEntityRegistry.SUGAR_STAFF_HEX.get()).m_20615_(player.m_9236_());
                sugarStaffHexEntity.setOwner((LivingEntity)player);
                sugarStaffHexEntity.m_146884_(realHitResult.m_82450_());
                sugarStaffHexEntity.setHexScale(1.0f + 0.25f * (float)humunguous);
                level.m_7967_((Entity)sugarStaffHexEntity);
                level.m_5594_(null, player.m_20183_(), (SoundEvent)ACSoundRegistry.SUGAR_STAFF_CAST_HEX.get(), SoundSource.PLAYERS, 1.0f, 0.0f);
                sugarStaffHexEntity.setLifespan(300 + 60 * itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SPELL_LASTING.get()));
                if (!player.m_7500_()) {
                    player.m_21206_().m_41774_(1);
                    player.m_36335_().m_41524_((Item)this, humunguous >= 2 ? 1400 : (humunguous == 1 ? 1200 : 1000));
                }
            } else {
                boolean seeking = itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SEEKCANDY.get()) > 0;
                boolean straight = itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.PEPPERMINT_PUNTING.get()) > 0;
                int multipleMint = itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.MULTIPLE_MINT.get());
                for (int layers = 1; layers < (multipleMint != 0 ? multipleMint + 2 : 2); ++layers) {
                    for (int l = 0; l < 5 * (2 + layers); ++l) {
                        this.makeRadiantPeppermint(5 * (2 + layers), l, level, (LivingEntity)player, 12 / layers != 0 ? 12.0f / (float)layers : 1.0f, 2.5f + (float)layers - 1.0f, 200, straight, seeking, lookingAtEntity);
                    }
                }
                if (!player.m_7500_()) {
                    player.m_21206_().m_41774_(1);
                    player.m_36335_().m_41524_((Item)this, seeking ? (multipleMint >= 2 ? 800 : (multipleMint == 1 ? 700 : 600)) : (multipleMint >= 2 ? 600 : (multipleMint == 1 ? 500 : 400)));
                }
                level.m_5594_((Player)null, player.m_20183_(), (SoundEvent)ACSoundRegistry.SUGAR_STAFF_CAST_PEPPERMINT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            ACExUtils.awardAdvancement((Entity)player, "radiant_wrath", "powered");
            itemstack.m_41622_(10, (LivingEntity)player, player1 -> player1.m_21190_(player1.m_7655_()));
            cir.setReturnValue((Object)InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_()));
        }
    }

    public void makeRadiantPeppermint(int amountOfPeppermint, float loopInt, Level level, LivingEntity living, float spinSpeed, float spinRadius, int setLifespan, boolean setStraight, boolean seeking, Entity lookingAtEntity) {
        SpinningPeppermintEntity peppermint = (SpinningPeppermintEntity)((EntityType)ACEntityRegistry.SPINNING_PEPPERMINT.get()).m_20615_(living.m_9236_());
        peppermint.m_146884_(living.m_20182_().m_82520_(0.0, (double)(living.m_20206_() * 0.45f), 0.0));
        if (seeking) {
            peppermint.setSeekingEntityId(lookingAtEntity.m_19879_());
        }
        peppermint.getPersistentData().m_128379_("PepperRadiant", true);
        peppermint.setStraight(setStraight);
        peppermint.m_146922_(180.0f + (loopInt - 1.0f) * 30.0f);
        peppermint.setSpinSpeed(spinSpeed);
        peppermint.setSpinRadius(spinRadius);
        peppermint.setOwner(living);
        peppermint.setStartAngle(loopInt * 360.0f / (float)amountOfPeppermint);
        peppermint.setLifespan(setLifespan);
        level.m_7967_((Entity)peppermint);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (pAttacker.m_21206_().m_150930_((Item)ACItemRegistry.RADIANT_ESSENCE.get())) {
            Player player;
            pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 1500, 9));
            if (pAttacker instanceof Player && !(player = (Player)pAttacker).m_7500_()) {
                pAttacker.m_21206_().m_41774_(1);
                player.m_36335_().m_41524_((Item)this, 400);
            }
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }
}

