/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.misc;

import com.github.alexmodguy.alexscaves.server.entity.ai.HullbreakerInspectMobGoal;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.compat.CuriosCompat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HullbreakerInspectMobGoal.class})
public abstract class ACExHullbreakerGoalMixin
extends Goal {
    @Shadow
    private LivingEntity inspectingTarget;
    @Shadow
    private HullbreakerEntity entity;
    @Shadow
    private int phaseTime;
    @Shadow
    private int maxPhaseTime;
    @Shadow
    private boolean staring;
    @Shadow
    private Vec3 startCirclingAt;
    @Shadow
    private boolean clockwise;
    private static final Predicate<LivingEntity> NEW_TARGETTING = mob -> HullbreakerEntity.GLOWING_TARGET.test(mob) || CuriosCompat.hasLight(mob);

    @Shadow
    public abstract boolean isPreyWatching();

    @Shadow
    public abstract Vec3 orbitAroundPos(Vec3 var1, float var2);

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        ci.cancel();
        double distance = this.entity.m_20270_((Entity)this.inspectingTarget);
        if (this.entity.getInterestLevel() >= 5 && NEW_TARGETTING.test(this.inspectingTarget)) {
            if (!(this.inspectingTarget instanceof Player) || !((Player)this.inspectingTarget).m_7500_()) {
                this.entity.m_6710_(this.inspectingTarget);
            }
            this.inspectingTarget = null;
        } else if (this.entity.m_217043_().m_188503_(20) == 0 && !NEW_TARGETTING.test(this.inspectingTarget)) {
            this.inspectingTarget = null;
        } else {
            if (this.entity.getAnimation() == HullbreakerEntity.ANIMATION_PUZZLE && this.entity.getAnimationTick() > 50) {
                this.phaseTime = this.maxPhaseTime;
            }
            if (this.phaseTime++ > this.maxPhaseTime) {
                this.entity.setInterestLevel(this.entity.getInterestLevel() + 1);
                this.staring = this.entity.m_217043_().m_188499_() && !this.staring;
                this.phaseTime = 0;
                this.startCirclingAt = this.inspectingTarget.m_146892_();
                int n = this.maxPhaseTime = this.staring ? 120 : 120 + 80 * Math.min(0, 5 - this.entity.getInterestLevel());
            }
            if (this.staring) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.inspectingTarget.m_146892_());
                if (this.isPreyWatching() && distance < 18.0) {
                    if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                        this.entity.setAnimation(HullbreakerEntity.ANIMATION_PUZZLE);
                    }
                    this.entity.m_21573_().m_26573_();
                } else if (this.entity.m_21573_().m_26571_()) {
                    Vec3 frontVision = this.inspectingTarget.m_146892_().m_82549_(this.inspectingTarget.m_20154_().m_82490_(12.0));
                    this.entity.m_21573_().m_26519_(frontVision.f_82479_, frontVision.f_82480_, frontVision.f_82481_, 1.0);
                }
            } else {
                if (this.startCirclingAt == null) {
                    this.startCirclingAt = this.inspectingTarget.m_146892_();
                }
                Vec3 circle = this.orbitAroundPos(this.inspectingTarget.m_146892_(), 12 + Math.min(0, 5 - this.entity.getInterestLevel()) * 3);
                this.entity.m_21573_().m_26519_(circle.f_82479_, circle.f_82480_, circle.f_82481_, (double)1.4f);
                this.entity.m_5616_(this.entity.f_20883_ + (float)(this.clockwise ? 30 : -30));
            }
            SubmarineEntity.alertSubmarineMountOf((LivingEntity)this.inspectingTarget);
        }
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        long worldTime = this.entity.m_9236_().m_46467_() % 10L;
        if (this.entity.m_217043_().m_188503_(60) == 0 || worldTime == 0L || target != null && target.m_6084_()) {
            AABB aabb = this.entity.m_20191_().m_82400_(80.0);
            List list = this.entity.m_9236_().m_6443_(LivingEntity.class, aabb, NEW_TARGETTING);
            if (list.isEmpty()) {
                return false;
            }
            LivingEntity closest = null;
            for (LivingEntity mob : list) {
                if (closest != null && !(mob.m_20280_((Entity)this.entity) < closest.m_20280_((Entity)this.entity)) || !this.entity.m_142582_((Entity)mob) || mob.m_7306_((Entity)this.entity)) continue;
                closest = mob;
            }
            this.inspectingTarget = closest;
            return this.inspectingTarget != null;
        }
        return false;
    }
}

