/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.external_mobs;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.util.FrostmintExplosion;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.SackOfSatingItem;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.datagen.tags.ACExBlockTagGenerator;
import org.crimsoncrips.alexscavesexemplified.datagen.tags.ACExItemTagGenerator;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ACExItemEntityMixin
extends Entity {
    @Shadow
    private int f_31986_;
    @Shadow
    @Nullable
    private UUID f_265881_;
    int timeToCook = 0;

    @Shadow
    public abstract ItemStack m_32055_();

    @Shadow
    @Nullable
    public abstract Entity m_19749_();

    public ACExItemEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")})
    private void playerTouch(Player pEntity, CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        if (!this.m_9236_().f_46443_ && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.TUNED_SATING_ENABLED.get()).booleanValue()) {
            ItemStack itemstack = itemEntity.m_32055_();
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)itemEntity, (Player)pEntity);
            if (this.f_31986_ <= 0 && (hook == 0 || itemstack.m_41613_() <= 0) && itemstack.m_41614_() && !pEntity.m_150109_().m_36054_(itemstack)) {
                Inventory inv = pEntity.m_150109_();
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    FoodProperties foodProperties;
                    ItemStack current = inv.m_8020_(i);
                    if (!(current.m_41720_() instanceof SackOfSatingItem)) continue;
                    if (itemstack.m_204117_(ACTagRegistry.EXPLODES_SACK_OF_SATING)) {
                        SackOfSatingItem.setExploding((ItemStack)current, (boolean)true);
                    }
                    int foodAmount = (foodProperties = itemstack.getFoodProperties((LivingEntity)pEntity)) != null && !itemstack.m_204117_(ACTagRegistry.RESTRICTED_FROM_SACK_OF_SATING) ? foodProperties.m_38744_() * itemstack.m_41613_() : 0;
                    SackOfSatingItem.setChewTimestamp((ItemStack)current, (long)pEntity.m_9236_().m_46467_());
                    SackOfSatingItem.setHunger((ItemStack)current, (int)(SackOfSatingItem.getHunger((ItemStack)current) + foodAmount));
                    ACExUtils.awardAdvancement((Entity)pEntity, "full_consumption", "full_consumed");
                    itemstack.m_41764_(0);
                    this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        ItemStack stack;
        Object object;
        BlockState blockState = this.m_20075_();
        Level level = this.m_9236_();
        ItemStack item = this.m_32055_();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.PURPLE_LEATHERED_ENABLED.get()).booleanValue() && (object = item.m_41720_()) instanceof DyeableLeatherItem) {
            DyeableLeatherItem dyeableLeatherItem = (DyeableLeatherItem)object;
            if (this.isInFluidType((FluidType)ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get()) && !dyeableLeatherItem.m_41113_(item)) {
                dyeableLeatherItem.m_41115_(item, 12073446);
                ACExUtils.awardAdvancement(this.m_19749_(), "purple_coloring", "colored");
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.BREAKING_CANDY_ENABLED.get()).booleanValue() && level.m_8055_(this.m_20183_()).m_60713_(Blocks.f_152476_) && item.m_204117_(ACExItemTagGenerator.GELATINABLE) && level.m_8055_(this.m_20183_().m_7495_()).m_204336_(ACExBlockTagGenerator.GELATIN_FIRE)) {
            for (ItemEntity itemEntity : this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(0.2))) {
                ItemStack nearBone = itemEntity.m_32055_();
                if (nearBone.m_41720_() instanceof DyeItem && this.timeToCook >= 50) {
                    ItemStack gelatinColor = switch (this.checkDye(nearBone)) {
                        case 2 -> ((Item)ACItemRegistry.GELATIN_PINK.get()).m_5456_().m_7968_();
                        case 3 -> ((Item)ACItemRegistry.GELATIN_GREEN.get()).m_5456_().m_7968_();
                        case 4 -> ((Item)ACItemRegistry.GELATIN_YELLOW.get()).m_5456_().m_7968_();
                        case 5 -> ((Item)ACItemRegistry.GELATIN_BLUE.get()).m_5456_().m_7968_();
                        default -> ((Item)ACItemRegistry.GELATIN_RED.get()).m_5456_().m_7968_();
                    };
                    this.m_32055_().m_41774_(1);
                    this.newGelatin(gelatinColor.m_41720_(), nearBone, item);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
                    ACExUtils.awardAdvancement(this.m_19749_(), "breaking_candy", "bake");
                    continue;
                }
                ++this.timeToCook;
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.AMPLIFIED_FROSTMINT_ENABLED.get()).booleanValue() && (item.m_150930_((Item)ACItemRegistry.FROSTMINT_SPEAR.get()) || item.m_150930_(((Block)ACBlockRegistry.FROSTMINT.get()).m_5456_()))) {
            if (blockState.m_60819_().getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get() && !level.f_46443_) {
                FrostmintExplosion explosion = new FrostmintExplosion(level, (Entity)this, this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, 4.0f, Explosion.BlockInteraction.DESTROY_WITH_DECAY, false);
                explosion.explode();
                explosion.finalizeExplosion(true);
                ACAdvancementTriggerRegistry.FROSTMINT_EXPLOSION.triggerForEntity(this.m_19749_());
                item.m_41774_(1);
            }
            ACExUtils.awardAdvancement(this.m_19749_(), "frostmint_explode", "explode");
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.TUNED_SATING_ENABLED.get()).booleanValue() && (stack = this.m_32055_()).m_41720_() instanceof SackOfSatingItem) {
            for (ItemEntity itemEntity : this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(1.0))) {
                FoodProperties foodProperties;
                Entity entity;
                ItemStack nearItemStack = itemEntity.m_32055_();
                if (nearItemStack.m_41619_() || !nearItemStack.m_41614_() || !((entity = this.m_19749_()) instanceof Player)) continue;
                Player player = (Player)entity;
                if (nearItemStack.m_204117_(ACTagRegistry.EXPLODES_SACK_OF_SATING)) {
                    SackOfSatingItem.setExploding((ItemStack)stack, (boolean)true);
                }
                int foodAmount = (foodProperties = nearItemStack.getFoodProperties((LivingEntity)player)) != null && !nearItemStack.m_204117_(ACTagRegistry.RESTRICTED_FROM_SACK_OF_SATING) ? foodProperties.m_38744_() * nearItemStack.m_41613_() : 0;
                SackOfSatingItem.setHunger((ItemStack)stack, (int)(SackOfSatingItem.getHunger((ItemStack)stack) + foodAmount));
                ACExUtils.awardAdvancement((Entity)player, "dropped_consumption", "consumed");
                nearItemStack.m_41764_(0);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            }
        }
    }

    public boolean m_5825_() {
        return super.m_5825_() || this.getPersistentData().m_128471_("DraggedProtection");
    }

    public int checkDye(ItemStack possibleDye) {
        int dyeDeterminer = 0;
        if (possibleDye.m_150930_(Items.f_42540_) || possibleDye.m_150930_(Items.f_42496_)) {
            dyeDeterminer += 3;
        }
        if (possibleDye.m_150930_(Items.f_42539_) || possibleDye.m_150930_(Items.f_42536_)) {
            dyeDeterminer += 4;
        }
        if (possibleDye.m_150930_(Items.f_42494_) || possibleDye.m_150930_(Items.f_42538_) || possibleDye.m_150930_(Items.f_42492_)) {
            dyeDeterminer += 5;
        }
        if (possibleDye.m_150930_(Items.f_42489_) || possibleDye.m_150930_(Items.f_42493_) || possibleDye.m_150930_(Items.f_42537_)) {
            dyeDeterminer += 2;
        }
        return dyeDeterminer;
    }

    public void newGelatin(Item gelatinColor, ItemStack bone, ItemStack item) {
        if (this.f_19796_.m_188500_() < 0.08) {
            bone.m_41774_(1);
        }
        if (this.f_19796_.m_188500_() < 0.03) {
            item.m_41774_(1);
        }
        this.timeToCook = 0;
        ItemEntity gelatin = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), gelatinColor.m_7968_());
        this.m_9236_().m_7967_((Entity)gelatin);
        gelatin.m_20334_((double)this.f_19796_.m_216339_(-1, 2) * 0.07, 0.4, (double)this.f_19796_.m_216339_(-1, 2) * 0.07);
    }
}

