/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.misc;

import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MagnetUtil;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.compat.CreateCompat;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;

public class ACExUtils {
    public static void dropMagneticItem(Player player, ItemStack item) {
        ItemEntity itementity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20188_(), player.m_20189_(), item);
        itementity.m_32010_(60);
        itementity.m_20256_(Vec3.f_82478_);
        player.m_9236_().m_7967_((Entity)itementity);
        MagnetUtil.setEntityMagneticDelta((Entity)itementity, (Vec3)MagnetUtil.getEntityMagneticDelta((Entity)player));
        MagnetUtil.setEntityMagneticDelta((Entity)player, (Vec3)Vec3.f_82478_);
        itementity.m_146915_(true);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ACExUtils.awardAdvancement((Entity)serverPlayer, "magnerip", "ripped");
        }
    }

    public static int getDivingAmount(LivingEntity entity) {
        int i = 0;
        if (entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ACItemRegistry.DIVING_HELMET.get())) {
            ++i;
        }
        if (entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ACItemRegistry.DIVING_CHESTPLATE.get())) {
            i += 2;
        }
        if (entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ACItemRegistry.DIVING_LEGGINGS.get())) {
            ++i;
        }
        if (entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ACItemRegistry.DIVING_BOOTS.get())) {
            ++i;
        }
        if (ModList.get().isLoaded("create")) {
            i += CreateCompat.createDivingSuit(entity);
        }
        return i;
    }

    public static void awardAdvancement(Entity entity, String advancementName, String criteria) {
        ServerPlayer serverPlayer;
        Advancement advancement;
        if (entity instanceof ServerPlayer && (advancement = (serverPlayer = (ServerPlayer)entity).m_284548_().m_7654_().m_129889_().m_136041_(new ResourceLocation("alexscavesexemplified", advancementName))) != null) {
            serverPlayer.m_8960_().m_135988_(advancement, criteria);
        }
    }

    public static void awardOutsideAdvancement(Entity entity, String advancementName, String criteria, String modId) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            System.out.println(modId);
            Advancement advancement = serverPlayer.m_284548_().m_7654_().m_129889_().m_136041_(new ResourceLocation(modId, advancementName));
            if (advancement != null) {
                serverPlayer.m_8960_().m_135988_(advancement, criteria);
            }
        }
    }

    public static Entity getLookingAtEntity(Player player) {
        EntityHitResult entityHitResult;
        Entity entity;
        Entity closestValid = null;
        HitResult hitresult = ProjectileUtil.m_278180_((Entity)player, Entity::m_6084_, (double)50.0);
        if (hitresult instanceof EntityHitResult && !(entity = (entityHitResult = (EntityHitResult)hitresult).m_82443_()).equals((Object)player) && player.m_142582_(entity)) {
            closestValid = entity;
        }
        return closestValid;
    }

    public static void spawnLoot(ResourceLocation location, LivingEntity entity, Entity owner, int loop) {
        if (!entity.m_9236_().f_46443_) {
            for (int i = 0; i <= loop; ++i) {
                LootParams ctx = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287235_(LootContextParamSets.f_81410_);
                ObjectArrayList rewards = entity.m_9236_().m_7654_().m_278653_().m_278676_(location).m_287195_(ctx);
                if (rewards.isEmpty()) continue;
                rewards.forEach(stack -> BehaviorUtils.m_22613_((LivingEntity)entity, (ItemStack)((ItemStack)rewards.get(0)), (Vec3)owner.m_20182_().m_82520_(0.0, 1.0, 0.0)));
            }
        }
    }

    public static void deepReputation(Entity entity, int amount) {
        for (DeepOneBaseEntity deepOne : entity.m_9236_().m_45976_(DeepOneBaseEntity.class, entity.m_20191_().m_82400_(40.0))) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            deepOne.addReputation(player.m_20148_(), amount);
            ACExUtils.awardAdvancement((Entity)player, "ecological_reputation", "affect");
        }
    }

    public static CompoundTag nbt(String name, Tag value) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_(name, value);
        return nbt;
    }

    public static void irradiationWash(LivingEntity entity, int amount) {
        MobEffectInstance irradiated;
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.IRRADIATION_WASHOFF_ENABLED.get()).booleanValue() && (irradiated = entity.m_21124_((MobEffect)ACEffectRegistry.IRRADIATED.get())) != null) {
            entity.m_21195_(irradiated.m_19544_());
            if (irradiated.m_19557_() > amount) {
                entity.m_7292_(new MobEffectInstance(irradiated.m_19544_(), irradiated.m_19557_() - amount, irradiated.m_19564_()));
            }
            ACExUtils.awardAdvancement((Entity)entity, "washing_radiation", "wash");
        }
    }

    static void yaw(PoseStack poseStack, float value) {
        poseStack.m_252781_(new Quaternionf(new AxisAngle4f(value, 0.0f, 1.0f, 0.0f)));
    }

    static void pitch(PoseStack poseStack, float value) {
        poseStack.m_252781_(new Quaternionf(new AxisAngle4f(value, 1.0f, 0.0f, 0.0f)));
    }

    static void roll(PoseStack poseStack, float value) {
        poseStack.m_252781_(new Quaternionf(new AxisAngle4f(value, 0.0f, 0.0f, 1.0f)));
    }
}

