/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nethersexorcismreborn.network;

import java.util.function.Supplier;
import net.mcreator.nethersexorcismreborn.NethersExorcismRebornMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NethersExorcismRebornModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NethersExorcismRebornMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.OverlayShow = message.data.OverlayShow;
                    variables.TextTimer = message.data.TextTimer;
                    variables.durab = message.data.durab;
                    variables.spaceIsPressed = message.data.spaceIsPressed;
                    variables.timebeforepoison = message.data.timebeforepoison;
                    variables.freq = message.data.freq;
                    variables.soundtimler = message.data.soundtimler;
                    variables.geigertext = message.data.geigertext;
                    variables.wearing_full_drifter_set = message.data.wearing_full_drifter_set;
                    variables.strampler_tamed = message.data.strampler_tamed;
                    variables.baby_strampler_killed = message.data.baby_strampler_killed;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean OverlayShow = false;
        public double TextTimer = 0.0;
        public double durab = 0.0;
        public boolean spaceIsPressed = false;
        public double timebeforepoison = 0.0;
        public double freq = 0.0;
        public double soundtimler = 0.0;
        public String geigertext = "\"\"";
        public boolean wearing_full_drifter_set = false;
        public double strampler_tamed = 0.0;
        public double baby_strampler_killed = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                NethersExorcismRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("OverlayShow", this.OverlayShow);
            nbt.m_128347_("TextTimer", this.TextTimer);
            nbt.m_128347_("durab", this.durab);
            nbt.m_128379_("spaceIsPressed", this.spaceIsPressed);
            nbt.m_128347_("timebeforepoison", this.timebeforepoison);
            nbt.m_128347_("freq", this.freq);
            nbt.m_128347_("soundtimler", this.soundtimler);
            nbt.m_128359_("geigertext", this.geigertext);
            nbt.m_128379_("wearing_full_drifter_set", this.wearing_full_drifter_set);
            nbt.m_128347_("strampler_tamed", this.strampler_tamed);
            nbt.m_128347_("baby_strampler_killed", this.baby_strampler_killed);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.OverlayShow = nbt.m_128471_("OverlayShow");
            this.TextTimer = nbt.m_128459_("TextTimer");
            this.durab = nbt.m_128459_("durab");
            this.spaceIsPressed = nbt.m_128471_("spaceIsPressed");
            this.timebeforepoison = nbt.m_128459_("timebeforepoison");
            this.freq = nbt.m_128459_("freq");
            this.soundtimler = nbt.m_128459_("soundtimler");
            this.geigertext = nbt.m_128461_("geigertext");
            this.wearing_full_drifter_set = nbt.m_128471_("wearing_full_drifter_set");
            this.strampler_tamed = nbt.m_128459_("strampler_tamed");
            this.baby_strampler_killed = nbt.m_128459_("baby_strampler_killed");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("nethers_exorcism_reborn", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.durab = original.durab;
            clone.spaceIsPressed = original.spaceIsPressed;
            clone.freq = original.freq;
            clone.soundtimler = original.soundtimler;
            clone.geigertext = original.geigertext;
            clone.strampler_tamed = original.strampler_tamed;
            clone.baby_strampler_killed = original.baby_strampler_killed;
            if (!event.isWasDeath()) {
                clone.OverlayShow = original.OverlayShow;
                clone.TextTimer = original.TextTimer;
                clone.timebeforepoison = original.timebeforepoison;
                clone.wearing_full_drifter_set = original.wearing_full_drifter_set;
            }
        }
    }
}

