/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.verify;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.CertificateHelper;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.slf4j.Logger;

public class JarSignVerifier {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void checkSigned(String modid) {
        Stopwatch watch = Stopwatch.createStarted();
        VerifyStatus status = JarSignVerifier.verify(modid);
        watch.stop();
        LOGGER.debug("Took {} to check if mod {} is signed.", (Object)watch, (Object)modid);
        if (status == VerifyStatus.SIGNED) {
            LOGGER.info("Mod " + modid + " is signed with a valid certificate.");
        } else if (status == VerifyStatus.UNSIGNED) {
            LOGGER.warn("---------------------------------------------------------------------------------");
            LOGGER.warn("Mod " + modid + " is not signed with a valid certificate but should be signed.");
            LOGGER.warn("Please download the mod only from trusted sources such as curseforge.com!");
            LOGGER.warn("---------------------------------------------------------------------------------");
        } else if (status == VerifyStatus.DEV) {
            LOGGER.info("Mod " + modid + " is loaded in dev environment.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VerifyStatus verify(String modid) {
        if (!FMLEnvironment.production) {
            return VerifyStatus.DEV;
        }
        IModFileInfo info = ModList.get().getModFileById(modid);
        SecureJar jar = info.getFile().getSecureJar();
        Optional<String> fingerPrintOptional = JarSignVerifier.getFingerPrint(Optional.ofNullable(jar.moduleDataProvider().getManifest()));
        if (fingerPrintOptional.isEmpty()) {
            return VerifyStatus.UNSIGNED;
        }
        String fingerprint = fingerPrintOptional.get();
        try (Stream<Path> paths = Files.find(jar.getRootPath(), Integer.MAX_VALUE, JarSignVerifier::validPath, new FileVisitOption[0]);){
            if (jar.getManifestSigners() == null || ((Stream)paths.parallel()).map(path -> JarSignVerifier.pathSigned(jar, path, fingerprint)).anyMatch(signed -> signed == false)) {
                VerifyStatus verifyStatus2 = VerifyStatus.UNSIGNED;
                return verifyStatus2;
            }
            VerifyStatus verifyStatus = VerifyStatus.SIGNED;
            return verifyStatus;
        }
        catch (Exception ex) {
            return VerifyStatus.UNSIGNED;
        }
    }

    private static boolean validPath(Path path, BasicFileAttributes attributes) {
        if (path.getNameCount() < 0 || !attributes.isRegularFile()) {
            return false;
        }
        String name = path.getFileName().toString().toUpperCase(Locale.ROOT);
        return !name.endsWith(".SF") && !name.endsWith(".DSA") && !name.endsWith(".EC") && !name.endsWith(".RSA");
    }

    private static Optional<String> getFingerPrint(Optional<Manifest> manifest) {
        return manifest.map(Manifest::getMainAttributes).map(attributes -> attributes.getValue("Fingerprint")).map(fingerPrint -> fingerPrint.replace(":", "").toLowerCase(Locale.ROOT));
    }

    private static boolean pathSigned(SecureJar jar, Path path, String fingerprint) {
        LOGGER.trace("Check {} for valid signature.", (Object)path);
        if (jar.verifyPath(path) != SecureJar.Status.VERIFIED) {
            return false;
        }
        CodeSigner[] codeSigners = jar.moduleDataProvider().verifyAndGetSigners(path.toString(), new byte[0]);
        return CertificateHelper.getFingerprints((Certificate[])((Certificate[])Stream.of(codeSigners).flatMap(signers -> signers.getSignerCertPath().getCertificates().stream()).toArray(Certificate[]::new))).stream().filter(fingerprint::equals).findAny().isPresent();
    }

    public static enum VerifyStatus {
        SIGNED,
        UNSIGNED,
        DEV;

    }
}

