/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import info.u_team.u_team_core.ingredient.FluidIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SerializeUtil {
    public static JsonElement serializeItemIngredient(Ingredient ingredient) {
        return ingredient.m_43942_();
    }

    public static Ingredient deserializeItemIngredient(JsonElement json) {
        return Ingredient.m_43917_((JsonElement)json);
    }

    public static JsonElement serializeFluidIngredient(FluidIngredient ingredient) {
        return ingredient.serialize();
    }

    public static FluidIngredient deserializeFluidIngredient(JsonElement json) {
        return FluidIngredient.deserialize(json);
    }

    public static JsonElement serializeItemStack(ItemStack stack) {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
        int count = stack.m_41613_();
        if (stack.m_41782_() || count != 1) {
            JsonObject object = new JsonObject();
            object.addProperty("item", itemName);
            if (count != 1) {
                object.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                object.addProperty("nbt", stack.m_41783_().toString());
            }
            return object;
        }
        return new JsonPrimitive(itemName);
    }

    public static ItemStack deserializeItemStack(JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject(), (boolean)true);
            }
            if (json.isJsonPrimitive()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.getAsString()));
                if (item == null) {
                    throw new IllegalStateException("Item: " + json.getAsString() + " does not exist");
                }
                return new ItemStack((ItemLike)item);
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }
}

