/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.screen;

import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.RenderTickable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.u_team_core.screen.FluidContainerMenuScreen;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UContainerMenuScreen<T extends AbstractContainerMenu>
extends FluidContainerMenuScreen<T>
implements PerspectiveRenderable,
TooltipRenderable {
    protected static final RGBA DEFAULT_TEXT_COLOR = new RGBA(0x404040FF);
    protected ResourceLocation background;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected RGBA backgroundColor;
    protected boolean drawTitleText;
    protected boolean drawInventoryText;
    protected RGBA textColor;

    public UContainerMenuScreen(T menu, Inventory playerInventory, Component title, ResourceLocation background, int imageWidth, int imageHeight) {
        this(menu, playerInventory, title, background);
        this.setImageDimensions(imageWidth, imageHeight);
    }

    public UContainerMenuScreen(T menu, Inventory playerInventory, Component title, ResourceLocation background) {
        super(menu, playerInventory, title);
        this.background = background;
        this.backgroundWidth = 256;
        this.backgroundHeight = 256;
        this.backgroundColor = RGBA.WHITE;
        this.drawTitleText = true;
        this.drawInventoryText = true;
        this.textColor = DEFAULT_TEXT_COLOR;
    }

    protected void setBackground(ResourceLocation background) {
        this.background = background;
    }

    protected void setBackgroundDimensions(int size) {
        this.setBackgroundDimensions(size, size);
    }

    protected void setBackgroundDimensions(int backgroundWidth, int backgroundHeight) {
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    protected void setImageDimensions(int imageWidth, int imageHeight) {
        this.f_97726_ = imageWidth;
        this.f_97727_ = imageHeight;
        this.setDefaultTextLocation();
    }

    protected void setDrawText(boolean drawTitleText, boolean drawInventoryText) {
        this.drawTitleText = drawTitleText;
        this.drawInventoryText = drawInventoryText;
    }

    protected void setDefaultTextLocation() {
        this.setTextLocation(8, 6, 8, this.f_97727_ - 94);
    }

    protected void setTextLocation(int titleLabelX, int titleLabelY, int inventoryLabelX, int inventoryLabelY) {
        this.f_97728_ = titleLabelX;
        this.f_97729_ = titleLabelY;
        this.f_97730_ = inventoryLabelX;
        this.f_97731_ = inventoryLabelY;
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderForeground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        if (this.drawTitleText) {
            guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, this.textColor.getColorARGB(), false);
        }
        if (this.drawInventoryText) {
            guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, this.textColor.getColorARGB(), false);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderUtil.drawTexturedQuad(guiGraphics.m_280168_(), this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 0.0f, this.background, this.backgroundColor);
    }

    public void m_181908_() {
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof RenderTickable)) continue;
            RenderTickable tickable = (RenderTickable)listener;
            tickable.renderTick();
        }
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof UContainerMenu) {
            UContainerMenu uMenu = (UContainerMenu)abstractContainerMenu;
            uMenu.broadcastChangesToServer();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        GuiEventListener focused = this.m_7222_();
        if (focused != null && this.m_7282_() && button == 0) {
            focused.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }
}

