/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetworkHandler
implements NetworkHandler {
    private final String protocolVersion;
    private Predicate<String> clientAcceptedVersions;
    private Predicate<String> serverAcceptedVersions;
    private final SimpleChannel network;

    ForgeNetworkHandler(String protocolVersion, ResourceLocation channel) {
        this.protocolVersion = protocolVersion;
        this.clientAcceptedVersions = protocolVersion::equals;
        this.serverAcceptedVersions = protocolVersion::equals;
        this.network = NetworkRegistry.newSimpleChannel((ResourceLocation)channel, () -> protocolVersion, version -> this.clientAcceptedVersions.test((String)version), version -> this.serverAcceptedVersions.test((String)version));
    }

    @Override
    public <M> void registerMessage(int index, Class<M> clazz, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, NetworkContext> messageConsumer, Optional<NetworkEnvironment> handlerEnvironment) {
        this.network.registerMessage(index, clazz, encoder, decoder, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            messageConsumer.accept(message, new ForgeNetworkContext(context));
            context.setPacketHandled(true);
        }, handlerEnvironment.map(environment -> switch (environment) {
            default -> throw new IncompatibleClassChangeError();
            case NetworkEnvironment.CLIENT -> NetworkDirection.PLAY_TO_CLIENT;
            case NetworkEnvironment.SERVER -> NetworkDirection.PLAY_TO_SERVER;
        }));
    }

    @Override
    public <M> void sendToPlayer(ServerPlayer player, M message) {
        this.network.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    @Override
    public <M> void sendToServer(M message) {
        this.network.send(PacketDistributor.SERVER.noArg(), message);
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolAcceptor(Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        this.clientAcceptedVersions = clientAcceptedVersions;
        this.serverAcceptedVersions = serverAcceptedVersions;
    }

    public static class ForgeNetworkContext
    implements NetworkContext {
        private final NetworkEvent.Context context;

        ForgeNetworkContext(NetworkEvent.Context context) {
            this.context = context;
        }

        @Override
        public NetworkEnvironment getEnvironment() {
            return switch (this.context.getDirection().getReceptionSide()) {
                default -> throw new IncompatibleClassChangeError();
                case LogicalSide.CLIENT -> NetworkEnvironment.CLIENT;
                case LogicalSide.SERVER -> NetworkEnvironment.SERVER;
            };
        }

        @Override
        public Player getPlayer() {
            if (this.context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                return (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Client.getClientPlayer());
            }
            return this.context.getSender();
        }

        @Override
        public void executeOnMainThread(Runnable runnable) {
            this.context.enqueueWork(runnable);
        }
    }

    public static class Factory
    implements NetworkHandler.Factory {
        @Override
        public NetworkHandler create(String protocolVersion, ResourceLocation location) {
            return new ForgeNetworkHandler(protocolVersion, location);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class Client {
        private Client() {
        }

        @OnlyIn(value=Dist.CLIENT)
        private static Player getClientPlayer() {
            return Minecraft.m_91087_().f_91074_;
        }
    }
}

