/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.util.ServiceUtil;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public interface NetworkHandler {
    public static NetworkHandler create(String protocolVersion, ResourceLocation location) {
        return Factory.INSTANCE.create(protocolVersion, location);
    }

    default public <M> void registerMessage(int index, Class<M> clazz, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, NetworkContext> messageConsumer) {
        this.registerMessage(index, clazz, encoder, decoder, messageConsumer, Optional.empty());
    }

    public <M> void registerMessage(int var1, Class<M> var2, BiConsumer<M, FriendlyByteBuf> var3, Function<FriendlyByteBuf, M> var4, BiConsumer<M, NetworkContext> var5, Optional<NetworkEnvironment> var6);

    public <M> void sendToPlayer(ServerPlayer var1, M var2);

    public <M> void sendToServer(M var1);

    public String getProtocolVersion();

    public void setProtocolAcceptor(Predicate<String> var1, Predicate<String> var2);

    public static interface Factory {
        public static final Factory INSTANCE = ServiceUtil.loadOne(Factory.class);

        public NetworkHandler create(String var1, ResourceLocation var2);
    }
}

