/*
 * Decompiled with CFR 0.152.
 */
package reloc.net.fabricmc.accesswidener;

import reloc.net.fabricmc.accesswidener.AccessWidenerReader;
import reloc.net.fabricmc.accesswidener.AccessWidenerVisitor;

public final class AccessWidenerWriter
implements AccessWidenerVisitor {
    private final StringBuilder builder = new StringBuilder();
    private final int version;
    private String namespace;

    public AccessWidenerWriter(int version) {
        this.version = version;
    }

    public AccessWidenerWriter() {
        this(2);
    }

    @Override
    public void visitHeader(String namespace) {
        if (this.namespace == null) {
            this.builder.append("accessWidener\tv").append(this.version).append('\t').append(namespace).append('\n');
        } else if (!this.namespace.equals(namespace)) {
            throw new IllegalArgumentException("Cannot write different namespaces to the same file (" + this.namespace + " != " + namespace + ")");
        }
        this.namespace = namespace;
    }

    @Override
    public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
        this.writeAccess(access, transitive);
        this.builder.append("\tclass\t").append(name).append('\n');
    }

    @Override
    public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        this.writeAccess(access, transitive);
        this.builder.append("\tmethod\t").append(owner).append('\t').append(name).append('\t').append(descriptor).append('\n');
    }

    @Override
    public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        this.writeAccess(access, transitive);
        this.builder.append("\tfield\t").append(owner).append('\t').append(name).append('\t').append(descriptor).append('\n');
    }

    public byte[] write() {
        return this.writeString().getBytes(AccessWidenerReader.ENCODING);
    }

    public String writeString() {
        if (this.namespace == null) {
            throw new IllegalStateException("No namespace set. visitHeader wasn't called.");
        }
        return this.builder.toString();
    }

    private void writeAccess(AccessWidenerReader.AccessType access, boolean transitive) {
        if (transitive) {
            if (this.version < 2) {
                throw new IllegalStateException("Cannot write transitive rule in version " + this.version);
            }
            this.builder.append("transitive-");
        }
        this.builder.append((Object)access);
    }
}

