/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.util.provider.ClassLookup;

public class InheritanceHandler {
    private final ClassLookup classProvider;
    private final Map<String, Collection<String>> parentCache = new HashMap<String, Collection<String>>();

    public InheritanceHandler(ClassLookup classProvider) {
        this.classProvider = classProvider;
    }

    public boolean isClassInherited(String child, String parent) {
        if (child.equals(parent)) {
            return true;
        }
        ClassNode childNode = this.classProvider.getClass(child).orElse(null);
        ClassNode parentNode = this.classProvider.getClass(parent).orElse(null);
        return childNode != null && parentNode != null && this.getClassParents(child).contains(parent);
    }

    public boolean isMethodOverriden(String cls, String name, String desc) {
        for (String parent : this.getClassParents(cls)) {
            ClassNode node = this.classProvider.getClass(parent).orElse(null);
            if (node == null) continue;
            for (MethodNode method : node.methods) {
                if (!method.name.equals(name) || !method.desc.equals(desc) || (method.access & 2) != 0 || (method.access & 0x10) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<String> getClassParents(String name) {
        Collection<String> parents = this.parentCache.get(name);
        if (parents == null) {
            parents = this.computeClassParents(name);
            this.parentCache.put(name, parents);
        }
        return parents;
    }

    private Collection<String> computeClassParents(String name) {
        ClassNode node = this.classProvider.getClass(name).orElse(null);
        HashSet<String> parents = new HashSet<String>();
        if (node != null) {
            if (node.superName != null) {
                parents.add(node.superName);
                if (!node.superName.equals("java/lang/Object")) {
                    parents.addAll(this.getClassParents(node.superName));
                }
            }
            if (node.interfaces != null) {
                parents.addAll(node.interfaces);
                for (String itf : node.interfaces) {
                    parents.addAll(this.getClassParents(itf));
                }
            }
        }
        return parents;
    }
}

