/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.mixin;

import com.mojang.datafixers.util.Pair;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import com.supermartijn642.formations.structure.processors.WaterloggingProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureTemplate.class})
public class StructureTemplateMixin {
    @Inject(method={"placeInWorld(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Lnet/minecraft/util/RandomSource;I)Z"}, at={@At(value="HEAD")})
    private void placeInWorld(ServerLevelAccessor level, BlockPos structurePosition, BlockPos piecePosition, StructurePlaceSettings placeSettings, RandomSource random, int setBlockFlags, CallbackInfoReturnable<Boolean> ci) {
        for (StructureProcessor processor : placeSettings.m_74411_()) {
            if (!(processor instanceof WaterloggingProcessor)) continue;
            placeSettings.m_163782_(false);
            return;
        }
    }

    @ModifyVariable(method={"processBlockInfos(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Ljava/util/List;"}, at=@At(value="HEAD"), ordinal=0, remap=false)
    private static List<StructureTemplate.StructureBlockInfo> processBlockInfos(List<StructureTemplate.StructureBlockInfo> blocks, ServerLevelAccessor level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings) {
        ArrayList<FormationsStructureProcessor> processors = null;
        for (StructureProcessor processor : placeSettings.m_74411_()) {
            if (!(processor instanceof FormationsStructureProcessor)) continue;
            if (processors == null) {
                processors = new ArrayList<FormationsStructureProcessor>();
            }
            processors.add((FormationsStructureProcessor)processor);
        }
        if (processors == null) {
            return blocks;
        }
        HashMap<BlockPos, Pair> blocksByPosition = new HashMap<BlockPos, Pair>(blocks.size());
        Map<BlockPos, BlockInstance> blockView = new HashMap(blocks.size());
        for (StructureTemplate.StructureBlockInfo block : blocks) {
            BlockPos realPosition = StructureTemplate.m_74563_((StructurePlaceSettings)placeSettings, (BlockPos)block.f_74675_()).m_121955_((Vec3i)piecePosition);
            BlockInstance blockInstance = new BlockInstance(block.f_74676_(), block.f_74677_());
            blocksByPosition.put(realPosition, Pair.of((Object)block.f_74675_(), (Object)blockInstance));
            blockView.put(realPosition, blockInstance);
        }
        blockView = Collections.unmodifiableMap(blockView);
        ArrayList<StructureTemplate.StructureBlockInfo> newBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>(blocks.size());
        for (Map.Entry entry : blocksByPosition.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            BlockInstance block = (BlockInstance)((Pair)entry.getValue()).getSecond();
            for (FormationsStructureProcessor processor : processors) {
                try {
                    BlockInstance newBlock = processor.processBlock(block, pos, (LevelReader)level, piecePosition, structurePosition, placeSettings, blockView);
                    if (newBlock == null) {
                        throw new NullPointerException("Processor returned null!");
                    }
                    block = newBlock;
                }
                catch (Exception e) {
                    Formations.LOGGER.error("Encountered an exception whilst processing block '{}' with processor of class '{}'!", new Object[]{block, processor.getClass(), e});
                }
            }
            if (block.state() == null) continue;
            newBlocks.add(new StructureTemplate.StructureBlockInfo((BlockPos)((Pair)entry.getValue()).getFirst(), block.state(), block.nbt()));
        }
        return newBlocks;
    }
}

