/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.network;

import io.github.flemmli97.mobbattle.items.ItemExtendedSpawnEgg;
import io.github.flemmli97.mobbattle.network.Packet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class C2SSpawnEgg
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("mobbattle", "c2s_spawn_egg");
    private final InteractionHand hand;
    private final String team;
    private final int amount;
    private final int spacing;

    public C2SSpawnEgg(InteractionHand hand, String team, int amount, int spacing) {
        this.hand = hand;
        this.team = team;
        this.amount = amount;
        this.spacing = spacing;
    }

    public static C2SSpawnEgg read(FriendlyByteBuf buf) {
        return new C2SSpawnEgg((InteractionHand)buf.m_130066_(InteractionHand.class), buf.m_130277_(), buf.readInt(), buf.readInt());
    }

    public static void handle(C2SSpawnEgg pkt, ServerPlayer sender) {
        ItemStack stack;
        if (sender != null && (stack = sender.m_21120_(pkt.hand)).m_41720_() instanceof ItemExtendedSpawnEgg) {
            ItemExtendedSpawnEgg.updateOptions(stack, new ItemExtendedSpawnEgg.SpawnOptions(pkt.team, pkt.amount, pkt.spacing));
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.hand);
        buf.m_130070_(this.team);
        buf.writeInt(this.amount);
        buf.writeInt(this.spacing);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }
}

