/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.items;

import com.google.common.base.Functions;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.handler.Utils;
import io.github.flemmli97.mobbattle.items.LeftClickInteractItem;
import io.github.flemmli97.mobbattle.network.S2CSpawnEggScreen;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ItemExtendedSpawnEgg
extends Item
implements LeftClickInteractItem {
    public ItemExtendedSpawnEgg(Item.Properties props) {
        super(props);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        list.add((Component)Component.m_237115_((String)"tooltip.spawnegg").m_130940_(ChatFormatting.AQUA));
        ResourceLocation id = ItemExtendedSpawnEgg.getNamedIdFrom(stack);
        if (id != null) {
            EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(id);
            CompoundTag compound = stack.m_41783_().m_128469_("mobbattle:Entity");
            list.add((Component)Component.m_237110_((String)("tooltip.spawnegg.spawn" + (compound.m_128440_() > 1 ? ".nbt" : "")), (Object[])new Object[]{type.m_20676_()}).m_130940_(ChatFormatting.GOLD));
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity living = CrossPlatformStuff.INSTANCE.tryGetEntity(entity);
        if (living instanceof Mob) {
            Mob mob = (Mob)living;
            if (!player.m_7500_()) {
                player.m_213846_((Component)Component.m_237115_((String)"tooltip.spawnegg.creative").m_130940_(ChatFormatting.GOLD));
                return true;
            }
            boolean nbt = false;
            CompoundTag compound = stack.m_41783_();
            if (compound == null) {
                compound = new CompoundTag();
            }
            CompoundTag tag = new CompoundTag();
            if (player.m_6144_()) {
                mob.m_20223_(tag);
                this.removeMobSpecifigTags(tag);
                nbt = true;
            } else {
                String name = BuiltInRegistries.f_256780_.m_7981_((Object)mob.m_6095_()).toString();
                if (name != null) {
                    tag.m_128359_("id", name);
                }
            }
            compound.m_128365_("mobbattle:Entity", (Tag)tag);
            stack.m_41751_(compound);
            if (!player.m_9236_().f_46443_) {
                player.m_213846_((Component)Component.m_237110_((String)("tooltip.spawnegg.save" + (nbt ? ".nbt" : "")), (Object[])new Object[]{mob.m_7755_()}).m_130940_(ChatFormatting.GOLD));
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity tile;
        if (ctx.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = ctx.m_43722_();
        if (!ctx.m_43723_().m_36204_(ctx.m_8083_().m_121945_(ctx.m_43719_()), ctx.m_43719_(), itemstack)) {
            return InteractionResult.PASS;
        }
        BlockState iblockstate = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (ItemExtendedSpawnEgg.hasSavedEntity(itemstack) && (tile = ctx.m_43725_().m_7702_(ctx.m_8083_())) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)tile;
            CompoundTag nbt = new CompoundTag();
            spawner.m_59801_().m_186381_(nbt);
            nbt.m_128473_("SpawnPotentials");
            nbt.m_128473_("SpawnData");
            SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)new SpawnData(itemstack.m_41783_().m_128469_("mobbattle:Entity"), Optional.empty())).resultOrPartial(string -> MobBattle.LOGGER.warn("Invalid SpawnData: {}", string)).ifPresent(t -> nbt.m_128365_("SpawnData", t));
            spawner.m_59801_().m_151328_(tile.m_58904_(), tile.m_58899_(), nbt);
            spawner.m_6596_();
            ctx.m_43725_().m_7260_(ctx.m_8083_(), iblockstate, iblockstate, 3);
            return InteractionResult.SUCCESS;
        }
        BlockPos blockpos = iblockstate.m_60812_((BlockGetter)ctx.m_43725_(), ctx.m_8083_()).m_83281_() ? ctx.m_8083_() : ctx.m_8083_().m_121945_(ctx.m_43719_());
        boolean spawned = ItemExtendedSpawnEgg.spawnEntity((ServerLevel)ctx.m_43725_(), itemstack, (double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, ctx.m_8125_());
        if (spawned && !ctx.m_43723_().m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_41782_() || !itemstack.m_41783_().m_128441_("mobbattle:Entity")) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockHitResult raytraceresult = ItemExtendedSpawnEgg.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
                boolean spawned;
                BlockPos blockpos = raytraceresult.m_82425_();
                if (!(world.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
                    return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
                }
                if (world.m_7966_(player, blockpos) && player.m_36204_(blockpos, raytraceresult.m_82434_(), itemstack) && (spawned = ItemExtendedSpawnEgg.spawnEntity((ServerLevel)world, itemstack, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, player.m_6350_())) && !player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            } else {
                CrossPlatformStuff.INSTANCE.sendToClient(new S2CSpawnEggScreen(hand), serverPlayer);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)player.m_9236_().f_46443_);
    }

    public static boolean spawnEntity(ServerLevel level, ItemStack stack, double x, double y, double z, Direction direction) {
        SpawnOptions options = ItemExtendedSpawnEgg.getOptions(stack);
        boolean success = false;
        int sqr = options.amount() > 1 ? (int)Math.ceil(Math.sqrt(options.amount())) : 0;
        for (int i = 0; i < options.amount(); ++i) {
            Entity entity = ItemExtendedSpawnEgg.getEntity((Level)level, stack);
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            CompoundTag tag = stack.m_41783_().m_128469_("mobbattle:Entity");
            if (options.amount() > 1 && options.spacing() > 0) {
                int dL = i / sqr;
                int dW = i % sqr - sqr / 2;
                Vec3i front = direction.m_122436_().m_142393_(options.spacing());
                Vec3i side = new Vec3i(front.m_123343_(), front.m_123342_(), -front.m_123341_());
                entity.m_7678_(x + (double)(side.m_123341_() * dW) + (double)(front.m_123341_() * dL), y, z + (double)(side.m_123343_() * dW) + (double)(front.m_123343_() * dL), Mth.m_14177_((float)(direction.m_122435_() - 180.0f)), 0.0f);
            } else {
                entity.m_7678_(x, y, z, Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
            }
            mob.f_20885_ = mob.m_146908_();
            mob.f_20883_ = mob.m_146908_();
            if (tag.m_128440_() == 1) {
                mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(BlockPos.m_274446_((Position)mob.m_20182_())), MobSpawnType.SPAWN_EGG, null, null);
            }
            level.m_7967_(entity);
            mob.m_8032_();
            if (options.team() != null && !options.team().isEmpty()) {
                Utils.updateEntity(options.team(), mob);
            }
            if (stack.m_41788_()) {
                entity.m_6593_(stack.m_41786_());
            }
            success = true;
        }
        return success;
    }

    public static Entity getEntity(Level level, ItemStack stack) {
        Entity entity = null;
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack)) {
            CompoundTag tag = stack.m_41783_().m_128469_("mobbattle:Entity");
            entity = EntityType.m_20645_((CompoundTag)tag, (Level)level, (Function)Functions.identity());
        }
        return entity;
    }

    public static SpawnOptions getOptions(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return new SpawnOptions((tag = tag.m_128469_("mobbattle:EntityOptions")).m_128441_("Team") ? tag.m_128461_("Team") : null, Math.max(1, tag.m_128451_("Amount")), Math.max(0, tag.m_128451_("Spacing")));
        }
        return new SpawnOptions(null, 1, 0);
    }

    public static void updateOptions(ItemStack stack, SpawnOptions options) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        CompoundTag optionsTag = new CompoundTag();
        if (options.team() != null && !options.team().isEmpty()) {
            optionsTag.m_128359_("Team", options.team());
        }
        if (options.amount() != 1) {
            optionsTag.m_128405_("Amount", options.amount());
        }
        if (options.spacing() != 0) {
            optionsTag.m_128405_("Spacing", options.spacing());
        }
        if (!optionsTag.m_128456_()) {
            tag.m_128365_("mobbattle:EntityOptions", (Tag)optionsTag);
            stack.m_41751_(tag);
        }
    }

    private static boolean hasSavedEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("mobbattle:Entity") && stack.m_41783_().m_128469_("mobbattle:Entity").m_128441_("id");
    }

    private void removeMobSpecifigTags(CompoundTag compound) {
        compound.m_128473_("Pos");
        compound.m_128473_("Motion");
        compound.m_128473_("Rotation");
        compound.m_128473_("UUID");
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack stack) {
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack)) {
            String s = stack.m_41783_().m_128469_("mobbattle:Entity").m_128461_("id");
            ResourceLocation resourcelocation = new ResourceLocation(s);
            if (!s.contains(":")) {
                stack.m_41783_().m_128469_("mobbattle:Entity").m_128359_("id", resourcelocation.toString());
            }
            return resourcelocation;
        }
        return null;
    }

    public boolean m_5812_(ItemStack stack) {
        return ItemExtendedSpawnEgg.hasSavedEntity(stack);
    }

    public record SpawnOptions(@Nullable String team, int amount, int spacing) {
        public SpawnOptions(@Nullable String team, int amount, int spacing) {
            this.team = team;
            this.amount = Mth.m_14045_((int)amount, (int)0, (int)100);
            this.spacing = Mth.m_14045_((int)spacing, (int)0, (int)99);
        }
    }
}

